/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.jaxrs.client;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.batch.runtime.JobInstance;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.batchee.jaxrs.client.BatchEEJAXRSClientBase;
import org.apache.batchee.jaxrs.client.ClientConfiguration;
import org.apache.batchee.jaxrs.client.ClientSecurity;
import org.apache.batchee.jaxrs.client.ClientSslConfiguration;
import org.apache.batchee.jaxrs.client.provider.Base64Filter;
import org.apache.batchee.jaxrs.common.JBatchResource;

class BatchEEJAXRS2Client
extends BatchEEJAXRSClientBase<Response> {
    private static final String BATCHEE_PATH = JBatchResource.class.getAnnotation(Path.class).value();
    private final WebTarget target;

    public BatchEEJAXRS2Client(ClientConfiguration configuration) {
        ClientSecurity security;
        String url = configuration.getBaseUrl().endsWith("/") ? configuration.getBaseUrl() + BATCHEE_PATH : configuration.getBaseUrl() + "/" + BATCHEE_PATH;
        ClientBuilder builder = ClientBuilder.newBuilder();
        ClientSslConfiguration ssl = configuration.getSsl();
        if (ssl != null) {
            if (ssl.getHostnameVerifier() != null) {
                builder = builder.hostnameVerifier(ssl.getHostnameVerifier());
            }
            if (ssl.getSslContext() != null) {
                builder = builder.sslContext(ssl.getSslContext());
            }
            if (ssl.getKeystore() != null) {
                builder.keyStore(ssl.getKeystore(), ssl.getKeystorePassword());
            }
        }
        WebTarget target = builder.build().target(url);
        if (configuration.getJsonProvider() != null) {
            target = (WebTarget)target.register(configuration.getJsonProvider());
        }
        if ((security = configuration.getSecurity()) != null) {
            if ("Basic".equalsIgnoreCase(security.getType())) {
                target = (WebTarget)target.register((Object)new Base64Filter(security.getUsername(), security.getPassword()));
            } else {
                throw new IllegalArgumentException("Security not supported: " + security.getType());
            }
        }
        this.target = target;
    }

    @Override
    protected Object extractEntity(Response response, Type type) throws Throwable {
        try {
            return Response.class.getMethod("readEntity", GenericType.class).invoke((Object)response, new GenericType(type));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
        catch (Exception e) {
            throw new IllegalStateException("Not using a JAXRS *2* API", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Response doInvoke(Method jaxrsMethod, Method method, Object[] args) {
        HashMap<String, Object> templates = new HashMap<String, Object>();
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        Object body = null;
        if (args != null) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length == 1 && JobInstance.class.equals(parameterTypes[0])) {
                JobInstance ji = (JobInstance)JobInstance.class.cast(args[0]);
                templates.put("id", ji.getInstanceId());
                templates.put("name", ji.getJobName());
            } else {
                void var9_10;
                Annotation[][] parameterAnnotations = jaxrsMethod.getParameterAnnotations();
                boolean bl = false;
                while (var9_10 < parameterAnnotations.length) {
                    Class<?> type = method.getParameterTypes()[var9_10];
                    boolean found = false;
                    for (Object a : parameterAnnotations[var9_10]) {
                        Class<? extends Annotation> at = a.annotationType();
                        if (PathParam.class.equals(at)) {
                            templates.put(((PathParam)PathParam.class.cast(a)).value(), BatchEEJAXRS2Client.convertParam(args[var9_10], type));
                            found = true;
                            continue;
                        }
                        if (!QueryParam.class.equals(at)) continue;
                        queryParams.put(((QueryParam)QueryParam.class.cast(a)).value(), BatchEEJAXRS2Client.convertParam(args[var9_10], type));
                        found = true;
                    }
                    if (!found) {
                        body = BatchEEJAXRS2Client.convertParam(args[var9_10], type);
                    }
                    ++var9_10;
                }
            }
        }
        WebTarget resolvedTarget = this.target.path(jaxrsMethod.getAnnotation(Path.class).value());
        for (Map.Entry entry : queryParams.entrySet()) {
            resolvedTarget = resolvedTarget.queryParam((String)entry.getKey(), new Object[]{entry.getValue()});
        }
        Invocation.Builder request = resolvedTarget.resolveTemplates(templates).request(new MediaType[]{this.findType(method.getReturnType())});
        if (jaxrsMethod.getAnnotation(GET.class) != null) {
            return request.get();
        }
        if (jaxrsMethod.getAnnotation(HEAD.class) != null) {
            return request.head();
        }
        if (jaxrsMethod.getAnnotation(POST.class) != null) {
            return request.post(Entity.entity((Object)body, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        }
        throw new IllegalArgumentException("Unexpected http method");
    }

    private MediaType findType(Class<?> returnType) {
        return returnType.isPrimitive() ? MediaType.TEXT_PLAIN_TYPE : MediaType.APPLICATION_JSON_TYPE;
    }

    @Override
    protected void close() {
    }
}

