/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.extras.writer;

import jakarta.batch.api.chunk.ItemWriter;
import java.io.Serializable;

public abstract class MultiWriterBase
implements ItemWriter {
    protected ItemWriter writer1;
    protected ItemWriter writer2;

    protected MultiWriterBase() {
    }

    protected MultiWriterBase(ItemWriter writer1, ItemWriter writer2) {
        this.init(writer1, writer2);
    }

    protected void init(ItemWriter writer1, ItemWriter writer2) {
        this.writer1 = writer1;
        this.writer2 = writer2;
    }

    public void open(Serializable serializable) throws Exception {
        if (Checkpoint.class.isInstance(serializable)) {
            Checkpoint cp = (Checkpoint)Checkpoint.class.cast(serializable);
            this.writer1.open(cp.checkpoint1);
            this.writer2.open(cp.checkpoint2);
        } else {
            if (serializable != null) {
                throw new IllegalArgumentException(String.valueOf(serializable) + " unsupported");
            }
            this.writer1.open(null);
            this.writer2.open(null);
        }
    }

    public void close() throws Exception {
        try {
            this.writer1.close();
        }
        catch (Exception e) {
            this.writer2.close();
            throw e;
        }
        this.writer2.close();
    }

    public Serializable checkpointInfo() throws Exception {
        return new Checkpoint(this.writer1.checkpointInfo(), this.writer2.checkpointInfo());
    }

    public static class Checkpoint
    implements Serializable {
        private Serializable checkpoint1;
        private Serializable checkpoint2;

        public Checkpoint(Serializable checkpoint1, Serializable checkpoint2) {
            this.checkpoint1 = checkpoint1;
            this.checkpoint2 = checkpoint2;
        }
    }
}

