/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.extras.jpa;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.ItemWriter;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import java.io.Serializable;
import java.util.List;
import org.apache.batchee.doc.api.Documentation;
import org.apache.batchee.extras.jpa.EntityManagerLocator;
import org.apache.batchee.extras.jpa.EntityManagerProvider;

@Documentation(value="Write all items using JPA")
public class JpaItemWriter
extends EntityManagerLocator
implements ItemWriter {
    @Inject
    @BatchProperty
    @Documentation(value="If set to true merge() will be used instead of persist()")
    private String useMerge;
    @Inject
    @BatchProperty
    @Documentation(value="Should JPA transaction be used (default false)")
    private String jpaTransaction;
    private boolean merge;
    private boolean transaction;

    public void open(Serializable checkpoint) throws Exception {
        this.emProvider = this.findEntityManager();
        this.merge = Boolean.parseBoolean(this.useMerge);
        this.transaction = Boolean.parseBoolean(this.jpaTransaction);
    }

    public void close() throws Exception {
        if (this.emProvider != null) {
            this.emProvider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeItems(List<Object> items) throws Exception {
        EntityManager em = ((EntityManagerProvider)this.emProvider.getValue()).newEntityManager();
        try {
            if (this.transaction) {
                em.getTransaction().begin();
            }
            for (Object o : items) {
                if (!this.merge) {
                    em.persist(o);
                    continue;
                }
                em.merge(o);
            }
            if (this.transaction) {
                em.getTransaction().commit();
            } else {
                em.flush();
            }
        }
        finally {
            ((EntityManagerProvider)this.emProvider.getValue()).release(em);
        }
    }

    public Serializable checkpointInfo() throws Exception {
        return null;
    }
}

