/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.extras.jpa;

import jakarta.batch.api.BatchProperty;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.batchee.doc.api.Documentation;
import org.apache.batchee.extras.jpa.EntityManagerProvider;
import org.apache.batchee.extras.locator.BeanLocator;

public class EntityManagerLocator {
    @Inject
    @BatchProperty
    @Documentation(value="The reference of qualified name of the proviedr for the entity manager")
    protected String entityManagerProvider;
    @Inject
    @BatchProperty
    @Documentation(value="The locator to use to find the entity manager provider")
    protected String locator;
    protected BeanLocator.LocatorInstance<EntityManagerProvider> emProvider;

    protected BeanLocator.LocatorInstance<EntityManagerProvider> findEntityManager() {
        if (this.entityManagerProvider != null && this.entityManagerProvider.startsWith("jndi:")) {
            return new BeanLocator.LocatorInstance<EntityManagerProvider>(new JndiEntityManagerProvider(this.entityManagerProvider.substring("jndi:".length())), null);
        }
        return BeanLocator.Finder.get(this.locator).newInstance(EntityManagerProvider.class, this.entityManagerProvider);
    }

    private static class JndiEntityManagerProvider
    implements EntityManagerProvider {
        private final String name;

        public JndiEntityManagerProvider(String jndi) {
            this.name = jndi;
        }

        @Override
        public EntityManager newEntityManager() {
            try {
                return (EntityManager)EntityManager.class.cast(new InitialContext().lookup(this.name));
            }
            catch (NamingException e) {
                throw new IllegalArgumentException("Wrong name: " + this.name);
            }
        }

        @Override
        public void release(EntityManager em) {
        }
    }
}

