/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.extras.async;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.ItemProcessor;
import jakarta.inject.Inject;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.batchee.doc.api.Documentation;
import org.apache.batchee.extras.locator.BeanLocator;

@Documentation(value="Processes asynchronously the items and send to the write a Future<?>.")
public class AsynchronousItemProcessor
implements ItemProcessor {
    protected ExecutorService es = null;
    protected ItemProcessor delegate = null;
    @Inject
    @BatchProperty
    @Documentation(value="the pool size, if <= 0 cached threads are used")
    private String poolSize;
    @Inject
    @BatchProperty
    @Documentation(value="Locator for the delegate processor")
    private String locator;
    @Inject
    @BatchProperty
    @Documentation(value="The actual processor (delegate)")
    private String delegateRef;

    protected ExecutorService getExecutor() {
        if (this.es == null) {
            if (this.poolSize == null || this.poolSize.trim().isEmpty()) {
                this.poolSize = "0";
            }
            int size = Integer.parseInt(this.poolSize);
            DaemonThreadFactory threadFactory = new DaemonThreadFactory();
            this.es = size <= 0 ? Executors.newCachedThreadPool(threadFactory) : Executors.newFixedThreadPool(size, threadFactory);
        }
        return this.es;
    }

    protected ItemProcessor getDelegate() {
        if (this.delegate == null) {
            this.delegate = BeanLocator.Finder.get(this.locator).newInstance(ItemProcessor.class, this.delegateRef).getValue();
        }
        return this.delegate;
    }

    public Object processItem(final Object o) throws Exception {
        return this.getExecutor().submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return AsynchronousItemProcessor.this.getDelegate().processItem(o);
            }
        });
    }

    public static class DaemonThreadFactory
    implements ThreadFactory {
        private static AtomicInteger ids = new AtomicInteger(0);
        private final ThreadGroup group;

        public DaemonThreadFactory() {
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.group, runnable, this.getClass().getSimpleName() + " - " + ids.incrementAndGet());
            if (!thread.isDaemon()) {
                thread.setDaemon(true);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }
}

