/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.extras.jpa;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemReader;
import javax.batch.operations.BatchRuntimeException;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.batchee.doc.api.Documentation;
import org.apache.batchee.extras.jpa.EntityManagerLocator;
import org.apache.batchee.extras.jpa.EntityManagerProvider;
import org.apache.batchee.extras.jpa.ParameterProvider;
import org.apache.batchee.extras.locator.BeanLocator;

@Documentation(value="Read JPA entities from a query.")
public class JpaItemReader
extends EntityManagerLocator
implements ItemReader {
    @Inject
    @BatchProperty
    @Documentation(value="The parameter provider ref or qualified name")
    private String parameterProvider;
    @Inject
    @BatchProperty
    @Documentation(value="The named query to execute")
    private String namedQuery;
    @Inject
    @BatchProperty
    @Documentation(value="The query to execute if the named query is empty")
    private String query;
    @Inject
    @BatchProperty
    @Documentation(value="Pagination size")
    private String pageSize;
    @Inject
    @BatchProperty
    @Documentation(value="Should entities be detached (default false)")
    private String detachEntities;
    @Inject
    @BatchProperty
    @Documentation(value="Should JPA transaction be used (default false)")
    private String jpaTransaction;
    private int page = 10;
    private int firstResult = 0;
    private BeanLocator.LocatorInstance<EntityManagerProvider> emProvider;
    private BeanLocator.LocatorInstance<ParameterProvider> paramProvider = null;
    private LinkedList<Object> items = new LinkedList();
    private boolean detach;
    private boolean transaction;

    public void open(Serializable checkpoint) throws Exception {
        BeanLocator beanLocator = BeanLocator.Finder.get(this.locator);
        this.emProvider = this.findEntityManager();
        if (this.parameterProvider != null) {
            this.paramProvider = beanLocator.newInstance(ParameterProvider.class, this.parameterProvider);
        }
        if (this.pageSize != null) {
            this.page = Integer.parseInt(this.pageSize, this.page);
        }
        if (this.namedQuery == null && this.query == null) {
            throw new BatchRuntimeException("a query should be provided");
        }
        this.detach = Boolean.parseBoolean(this.detachEntities);
        this.transaction = Boolean.parseBoolean(this.jpaTransaction);
    }

    public void close() throws Exception {
        if (this.emProvider != null) {
            this.emProvider.release();
        }
        if (this.paramProvider != null) {
            this.paramProvider.release();
        }
    }

    public Object readItem() throws Exception {
        if (this.items.isEmpty()) {
            Collection<?> objects = this.nextPage();
            if (objects == null || objects.isEmpty()) {
                return null;
            }
            this.items.addAll(objects);
            this.firstResult += this.items.size();
        }
        return this.items.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<?> nextPage() {
        EntityManager em = this.emProvider.getValue().newEntityManager();
        if (this.transaction) {
            em.getTransaction().begin();
        }
        try {
            Query jpaQuery = this.namedQuery != null ? em.createNamedQuery(this.namedQuery) : em.createQuery(this.query);
            jpaQuery.setFirstResult(this.firstResult).setMaxResults(this.page);
            if (this.paramProvider != null) {
                this.paramProvider.getValue().setParameters(jpaQuery);
            }
            List resultList = jpaQuery.getResultList();
            if (this.detach) {
                for (Object o : resultList) {
                    em.detach(o);
                }
            }
            List list = resultList;
            return list;
        }
        finally {
            if (this.transaction) {
                em.getTransaction().commit();
            }
            this.emProvider.getValue().release(em);
        }
    }

    public Serializable checkpointInfo() throws Exception {
        return null;
    }
}

