/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.extras.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import javax.batch.api.BatchProperty;
import javax.batch.api.Batchlet;
import javax.inject.Inject;
import org.apache.batchee.doc.api.Documentation;
import org.apache.batchee.extras.jdbc.JdbcConnectionConfiguration;
import org.apache.batchee.extras.transaction.integration.Synchronizations;

@Documentation(value="Executes an update or delete query.")
public class JdbcBatchlet
extends JdbcConnectionConfiguration
implements Batchlet {
    @Inject
    @BatchProperty
    @Documentation(value="The update query to execute (UPDATE or DELETE)")
    private String sql;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String process() throws Exception {
        Connection conn = this.connection();
        try {
            String string;
            PreparedStatement preparedStatement = conn.prepareStatement(this.sql);
            try {
                string = "" + preparedStatement.executeUpdate();
            }
            catch (Throwable throwable) {
                try {
                    preparedStatement.close();
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            preparedStatement.close();
            return string;
        }
        finally {
            if (!Synchronizations.hasTransaction()) {
                conn.commit();
            }
            conn.close();
        }
    }

    public void stop() throws Exception {
    }
}

