/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.extras.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import javax.batch.api.BatchProperty;
import javax.batch.operations.BatchRuntimeException;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public abstract class JdbcConnectionConfiguration {
    @Inject
    @BatchProperty
    private String jndi;
    @Inject
    @BatchProperty
    protected String driver;
    @Inject
    @BatchProperty
    protected String url;
    @Inject
    @BatchProperty
    protected String user;
    @Inject
    @BatchProperty
    protected String password;

    protected Connection connection() throws Exception {
        if (this.jndi != null) {
            return ((DataSource)DataSource.class.cast(new InitialContext().lookup(this.jndi))).getConnection();
        }
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            throw new BatchRuntimeException((Throwable)e);
        }
        return DriverManager.getConnection(this.url, this.user, this.password);
    }
}

