/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.csv;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;

class CSVFormatFactory {
    private CSVFormatFactory() {
    }

    static CSVFormat newFormat(String format, String delimiter, String quoteCharacter, String quoteMode, String commentMarker, String escapeCharacter, String ignoreSurroundingSpaces, String ignoreEmptyLines, String recordSeparator, String nullString, String headerComments, String header, String skipHeaderRecord, String allowMissingColumnNames, String readHeaders) {
        CSVFormat out;
        CSVFormat cSVFormat = out = format == null ? CSVFormat.DEFAULT : CSVFormat.valueOf((String)format);
        if (delimiter != null) {
            out = out.withDelimiter(delimiter.charAt(0));
        }
        if (quoteCharacter != null) {
            out = out.withQuote(quoteCharacter.charAt(0));
        }
        if (quoteMode != null) {
            out = out.withQuoteMode(QuoteMode.valueOf((String)quoteMode));
        }
        if (commentMarker != null) {
            out = out.withCommentMarker(commentMarker.charAt(0));
        }
        if (escapeCharacter != null) {
            out = out.withEscape(escapeCharacter.charAt(0));
        }
        if (ignoreSurroundingSpaces != null) {
            out = out.withIgnoreSurroundingSpaces(Boolean.parseBoolean(ignoreSurroundingSpaces));
        }
        if (ignoreEmptyLines != null) {
            out = out.withIgnoreEmptyLines(Boolean.parseBoolean(ignoreEmptyLines));
        }
        if (recordSeparator != null) {
            out = "\\n".equals(recordSeparator) ? out.withRecordSeparator('\n') : ("\\r\\n".equals(recordSeparator) ? out.withRecordSeparator("\r\n") : out.withRecordSeparator(recordSeparator));
        }
        if (nullString != null) {
            out = out.withNullString(nullString);
        }
        if (headerComments != null && !headerComments.trim().isEmpty()) {
            out = out.withHeaderComments((Object[])headerComments.split(" *, *"));
        }
        if (Boolean.parseBoolean(readHeaders)) {
            out = out.withHeader(new String[0]);
        }
        if (header != null && !header.trim().isEmpty()) {
            try {
                Iterator iterator = out.withHeader(new String[0]).parse((Reader)new StringReader(header + '\n' + header)).iterator();
                CSVRecord record = (CSVRecord)iterator.next();
                ArrayList<String> list = new ArrayList<String>(record.size());
                for (String h : record) {
                    list.add(h);
                }
                out = out.withHeader(list.toArray(new String[record.size()]));
            }
            catch (IOException e) {
                out = out.withHeader(header.split(" *, *"));
            }
        }
        if (skipHeaderRecord != null) {
            out = out.withSkipHeaderRecord(Boolean.parseBoolean(skipHeaderRecord));
        }
        if (allowMissingColumnNames != null) {
            out = out.withAllowMissingColumnNames(Boolean.parseBoolean(allowMissingColumnNames));
        }
        return out;
    }
}

