/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.cli.command;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import javax.batch.operations.JobOperator;
import javax.batch.runtime.BatchRuntime;
import org.apache.batchee.cli.classloader.ChildFirstURLClassLoader;
import org.apache.batchee.cli.command.api.Option;
import org.apache.batchee.cli.lifecycle.Lifecycle;
import org.apache.batchee.cli.zip.Zips;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;
import org.apache.batchee.jaxrs.client.BatchEEJAXRSClientFactory;
import org.apache.batchee.jaxrs.client.ClientConfiguration;
import org.apache.batchee.jaxrs.client.ClientSecurity;
import org.apache.batchee.jaxrs.client.ClientSslConfiguration;
import org.apache.commons.io.FileUtils;

public abstract class JobOperatorCommand
implements Runnable {
    @Option(name="url", description="when using JAXRS the batchee resource url")
    protected String baseUrl = null;
    @Option(name="json", description="when using JAXRS the json provider")
    private String jsonProvider = null;
    @Option(name="user", description="when using JAXRS the username")
    private String username = null;
    @Option(name="password", description="when using JAXRS the password")
    private String password = null;
    @Option(name="auth", description="when using JAXRS the authentication type (Basic)")
    private String type = "Basic";
    @Option(name="hostnameVerifier", description="when using JAXRS the hostname verifier")
    private String hostnameVerifier = null;
    @Option(name="keystorePassword", description="when using JAXRS the keystorePassword")
    private String keystorePassword = null;
    @Option(name="keystoreType", description="when using JAXRS the keystoreType (JKS)")
    private String keystoreType = "JKS";
    @Option(name="keystorePath", description="when using JAXRS the keystorePath")
    private String keystorePath = null;
    @Option(name="sslContextType", description="when using JAXRS the sslContextType (TLS)")
    private String sslContextType = "TLS";
    @Option(name="keyManagerType", description="when using JAXRS the keyManagerType (SunX509)")
    private String keyManagerType = "SunX509";
    @Option(name="keyManagerPath", description="when using JAXRS the keyManagerPath")
    private String keyManagerPath = null;
    @Option(name="trustManagerAlgorithm", description="when using JAXRS the trustManagerAlgorithm")
    private String trustManagerAlgorithm = null;
    @Option(name="trustManagerProvider", description="when using JAXRS the trustManagerProvider")
    private String trustManagerProvider = null;
    @Option(name="lifecycle", description="the lifecycle class to use")
    private String lifecycle = null;
    @Option(name="libs", description="folder containing additional libraries, the folder is added too to the loader")
    private String libs = null;
    @Option(name="archive", description="a bar archive")
    private String archive = null;
    @Option(name="work", description="work directory (default to java.io.tmp/work)")
    private String work = System.getProperty("batchee.home", System.getProperty("java.io.tmpdir")) + "/work";
    @Option(name="sharedLibs", description="folder containing shared libraries, the folder is added too to the loader")
    private String sharedLibs = null;
    @Option(name="addFolderToLoader", description="force shared lib and libs folders to be added to the classloader")
    private boolean addFolderToLoader = false;
    protected JobOperator operator;

    protected JobOperator operator() {
        if (this.operator != null) {
            return this.operator;
        }
        if (this.baseUrl == null) {
            this.operator = BatchRuntime.getJobOperator();
            return this.operator;
        }
        ClientConfiguration configuration = new ClientConfiguration();
        configuration.setBaseUrl(this.baseUrl);
        configuration.setJsonProvider(this.jsonProvider);
        if (this.hostnameVerifier != null || this.keystorePath != null || this.keyManagerPath != null) {
            ClientSslConfiguration ssl = new ClientSslConfiguration();
            configuration.setSsl(ssl);
            ssl.setHostnameVerifier(this.hostnameVerifier);
            ssl.setKeystorePassword(this.keystorePassword);
            ssl.setKeyManagerPath(this.keyManagerPath);
            ssl.setKeyManagerType(this.keyManagerType);
            ssl.setKeystorePath(this.keystorePath);
            ssl.setKeystoreType(this.keystoreType);
            ssl.setSslContextType(this.sslContextType);
            ssl.setTrustManagerAlgorithm(this.trustManagerAlgorithm);
            ssl.setTrustManagerProvider(this.trustManagerProvider);
        }
        ClientSecurity security = new ClientSecurity();
        configuration.setSecurity(security);
        security.setUsername(this.username);
        security.setPassword(this.password);
        security.setType(this.type);
        this.operator = BatchEEJAXRSClientFactory.newClient((ClientConfiguration)configuration);
        return this.operator;
    }

    protected void info(String text) {
        System.out.println(text);
    }

    protected abstract void doRun();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        ClassLoader loader;
        System.setProperty("org.apache.batchee.init.verbose.sysout", "true");
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            loader = this.createLoader(oldLoader);
        }
        catch (MalformedURLException e) {
            throw new BatchContainerRuntimeException((Throwable)e);
        }
        if (loader != oldLoader) {
            Thread.currentThread().setContextClassLoader(loader);
        }
        try {
            Object state;
            Lifecycle<Object> lifecycleInstance;
            if (this.lifecycle != null) {
                lifecycleInstance = this.createLifecycle(loader);
                state = lifecycleInstance.start();
            } else {
                lifecycleInstance = null;
                state = null;
            }
            try {
                this.doRun();
            }
            finally {
                if (lifecycleInstance != null) {
                    lifecycleInstance.stop(state);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    private Lifecycle<Object> createLifecycle(ClassLoader loader) {
        if ("openejb".equalsIgnoreCase(this.lifecycle)) {
            this.lifecycle = "org.apache.batchee.cli.lifecycle.impl.OpenEJBLifecycle";
        } else if ("cdi".equalsIgnoreCase(this.lifecycle)) {
            this.lifecycle = "org.apache.batchee.cli.lifecycle.impl.CdiCtrlLifecycle";
        } else if ("spring".equalsIgnoreCase(this.lifecycle)) {
            this.lifecycle = "org.apache.batchee.cli.lifecycle.impl.SpringLifecycle";
        }
        try {
            return (Lifecycle)loader.loadClass(this.lifecycle).newInstance();
        }
        catch (Exception e) {
            throw new BatchContainerRuntimeException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ClassLoader createLoader(ClassLoader parent) throws MalformedURLException {
        File folder;
        LinkedList<URL> urls = new LinkedList<URL>();
        if (this.libs != null && (folder = new File(this.libs)).exists()) {
            this.addFolder(folder, urls);
        }
        File resources = null;
        File exploded = null;
        if (this.archive != null) {
            File bar = new File(this.archive);
            if (!bar.exists()) throw new IllegalArgumentException("'" + this.archive + "' doesn't exist");
            if (bar.isFile()) {
                exploded = new File(this.work, bar.getName());
            } else {
                if (!bar.isDirectory()) throw new IllegalArgumentException("unsupported archive type for: '" + this.archive + "'");
                exploded = bar;
            }
            File timestamp = new File(exploded, "timestamp.txt");
            long ts = Long.MIN_VALUE;
            if (exploded.exists() && timestamp.exists()) {
                try {
                    ts = Long.parseLong(FileUtils.readFileToString((File)timestamp).trim());
                }
                catch (IOException e) {
                    ts = Long.MIN_VALUE;
                }
            }
            if (ts == Long.MIN_VALUE || ts < bar.lastModified()) {
                JobOperatorCommand.explode(bar, exploded, timestamp, bar.lastModified());
            }
            if (this.archive.endsWith(".bar") || new File(exploded, "BATCH-INF").exists()) {
                this.addFolder(new File(exploded, "BATCH-INF/classes"), urls);
                JobOperatorCommand.addFolderIfExist(new File(exploded, "BATCH-INF/lib"), urls);
                resources = new File(exploded, "BATCH-INF");
            } else {
                if (!this.archive.endsWith(".war") && !new File(exploded, "WEB-INF").exists()) throw new IllegalArgumentException("unknown or unsupported archive type: " + this.archive);
                JobOperatorCommand.addFolderIfExist(new File(exploded, "WEB-INF/classes"), urls);
                JobOperatorCommand.addLibs(new File(exploded, "WEB-INF/lib"), urls);
            }
        }
        ClassLoader sharedClassLoader = this.createSharedClassLoader(parent);
        if (this.libs == null && this.archive == null) {
            return sharedClassLoader;
        }
        ChildFirstURLClassLoader classLoader = new ChildFirstURLClassLoader(urls.toArray(new URL[urls.size()]), sharedClassLoader);
        if (resources != null && resources.exists()) {
            classLoader.addResource(resources);
        }
        if (exploded == null) return classLoader;
        classLoader.setApplicationFolder(exploded);
        return classLoader;
    }

    private static void addFolderIfExist(File file, Collection<URL> urls) throws MalformedURLException {
        if (file.isDirectory()) {
            urls.add(file.toURI().toURL());
        }
    }

    private ClassLoader createSharedClassLoader(ClassLoader parent) throws MalformedURLException {
        ClassLoader usedParent;
        if (this.sharedLibs != null) {
            LinkedList<URL> sharedUrls = new LinkedList<URL>();
            File folder = new File(this.sharedLibs);
            this.addJars(folder, sharedUrls);
            if (ChildFirstURLClassLoader.class.isInstance(parent)) {
                ((ChildFirstURLClassLoader)ChildFirstURLClassLoader.class.cast(parent)).addUrls(sharedUrls);
                usedParent = parent;
            } else {
                usedParent = new ChildFirstURLClassLoader(sharedUrls.toArray(new URL[sharedUrls.size()]), parent);
            }
        } else {
            usedParent = parent;
        }
        return usedParent;
    }

    private void addJars(File folder, Collection<URL> urls) throws MalformedURLException {
        if (!folder.isDirectory()) {
            return;
        }
        JobOperatorCommand.addLibs(folder, urls);
        if (this.addFolderToLoader) {
            urls.add(folder.toURI().toURL());
        }
    }

    private void addFolder(File folder, Collection<URL> urls) throws MalformedURLException {
        if (!folder.exists()) {
            return;
        }
        this.addJars(folder, urls);
        File[] subFolders = folder.listFiles(DirFilter.INSTANCE);
        if (subFolders != null) {
            for (File f : subFolders) {
                this.addJars(f, urls);
            }
        }
    }

    private static void addLibs(File folder, Collection<URL> urls) throws MalformedURLException {
        if (!folder.isDirectory()) {
            return;
        }
        File[] additionals = folder.listFiles(JarFilter.INSTANCE);
        if (additionals != null) {
            for (File toAdd : additionals) {
                urls.add(toAdd.toURI().toURL());
            }
        }
    }

    private static void explode(File source, File target, File timestampFile, long time) {
        try {
            FileUtils.deleteDirectory((File)target);
            Zips.unzip(source, target);
            FileUtils.write((File)timestampFile, (CharSequence)Long.toString(time));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class DirFilter
    implements FileFilter {
        public static final FileFilter INSTANCE = new DirFilter();

        private DirFilter() {
        }

        @Override
        public boolean accept(File dir) {
            return dir.isDirectory() && !dir.getName().startsWith(".");
        }
    }

    private static class JarFilter
    implements FilenameFilter {
        public static final FilenameFilter INSTANCE = new JarFilter();

        private JarFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar") || name.endsWith(".zip");
        }
    }
}

