/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.cdi.impl;

import java.lang.annotation.Annotation;
import java.util.LinkedList;
import javax.batch.runtime.context.StepContext;
import org.apache.batchee.cdi.impl.BaseContext;
import org.apache.batchee.cdi.impl.LocationHolder;
import org.apache.batchee.cdi.scope.StepScoped;

public class StepContextImpl
extends BaseContext<StepKey> {
    public static final BaseContext<?> INSTANCE = new StepContextImpl();

    private StepContextImpl() {
    }

    public Class<? extends Annotation> getScope() {
        return StepScoped.class;
    }

    protected StepKey[] currentKeys() {
        LinkedList<StepContext> stepContexts = LocationHolder.currentSteps();
        StepKey[] keys = new StepKey[stepContexts.size()];
        int i = 0;
        for (StepContext stepContext : stepContexts) {
            keys[i++] = new StepKey(stepContext.getStepExecutionId());
        }
        return keys;
    }

    public static class StepKey {
        private final long stepExecutionId;
        private final int hashCode;

        public StepKey(long stepExecutionId) {
            this.stepExecutionId = stepExecutionId;
            this.hashCode = (int)(stepExecutionId ^ stepExecutionId >>> 32);
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this.stepExecutionId == ((StepKey)StepKey.class.cast((Object)o)).stepExecutionId;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

