/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.beanio;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.Locale;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemReader;
import javax.inject.Inject;
import org.apache.batchee.beanio.BeanIOs;
import org.apache.batchee.doc.api.Documentation;
import org.apache.batchee.extras.transaction.CountedReader;
import org.beanio.BeanReader;
import org.beanio.BeanReaderErrorHandler;

@Documentation(value="Uses BeanIO to read a file.")
public class BeanIOReader
extends CountedReader
implements ItemReader {
    @Inject
    @BatchProperty(name="file")
    @Documentation(value="The file to read")
    protected String filePath;
    @Inject
    @BatchProperty(name="skippedHeaderLines")
    @Documentation(value="Number of lines to skip")
    protected int skippedHeaderLines;
    @Inject
    @BatchProperty
    @Documentation(value="The BeanIO stream name")
    protected String streamName;
    @Inject
    @BatchProperty
    @Documentation(value="The configuration path in the classpath")
    protected String configuration;
    @Inject
    @BatchProperty(name="locale")
    @Documentation(value="The locale to use")
    protected String localeStr;
    @Inject
    @BatchProperty(name="errorHandler")
    @Documentation(value="The error handler class (resolved using locator)")
    protected String errorHandlerStr;
    private BeanReader reader;

    public void open(Serializable checkpoint) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(this.filePath));
        for (int i = 0; i < this.skippedHeaderLines; ++i) {
            reader.readLine();
        }
        this.reader = BeanIOs.open(this.filePath, this.streamName, this.configuration).createReader(this.streamName, (Reader)reader, this.initLocale());
        if (this.errorHandlerStr != null) {
            BeanReaderErrorHandler handler = (BeanReaderErrorHandler)BeanReaderErrorHandler.class.cast(Thread.currentThread().getContextClassLoader().loadClass(this.errorHandlerStr).newInstance());
            this.reader.setErrorHandler(handler);
        }
        super.open(checkpoint);
    }

    public void close() throws Exception {
        this.reader.close();
    }

    protected Object doRead() throws Exception {
        return this.reader.read();
    }

    private Locale initLocale() {
        if (this.localeStr == null) {
            return Locale.getDefault();
        }
        String[] s = this.localeStr.split("_");
        if (s.length >= 3) {
            return new Locale(s[0], s[1], s[2]);
        }
        if (s.length == 2) {
            return new Locale(s[0], s[1]);
        }
        return new Locale(this.localeStr);
    }
}

