/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.beanio;

import java.io.FileReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.Locale;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemReader;
import javax.inject.Inject;
import org.apache.batchee.beanio.BeanIOs;
import org.apache.batchee.extras.transaction.CountedReader;
import org.beanio.BeanReader;
import org.beanio.BeanReaderErrorHandler;

public class BeanIOReader
extends CountedReader
implements ItemReader {
    @Inject
    @BatchProperty(name="file")
    protected String filePath;
    @Inject
    @BatchProperty
    protected String streamName;
    @Inject
    @BatchProperty
    protected String configuration;
    @Inject
    @BatchProperty(name="locale")
    protected String localeStr;
    @Inject
    @BatchProperty(name="errorHandler")
    protected String errorHandlerStr;
    private BeanReader reader;

    public void open(Serializable checkpoint) throws Exception {
        this.reader = BeanIOs.open(this.filePath, this.streamName, this.configuration).createReader(this.streamName, (Reader)new FileReader(this.filePath), this.initLocale());
        if (this.errorHandlerStr != null) {
            BeanReaderErrorHandler handler = (BeanReaderErrorHandler)BeanReaderErrorHandler.class.cast(Thread.currentThread().getContextClassLoader().loadClass(this.errorHandlerStr).newInstance());
            this.reader.setErrorHandler(handler);
        }
        super.open(checkpoint);
    }

    public void close() throws Exception {
        this.reader.close();
    }

    protected Object doRead() throws Exception {
        return this.reader.read();
    }

    private Locale initLocale() {
        if (this.localeStr == null) {
            return Locale.getDefault();
        }
        String[] s = this.localeStr.split("_");
        if (s.length >= 3) {
            return new Locale(s[0], s[1], s[2]);
        }
        if (s.length == 2) {
            return new Locale(s[0], s[1]);
        }
        return new Locale(this.localeStr);
    }
}

