/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.local;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.kernel.http.HTTPConstants;
import org.apache.axis2.transport.local.LocalResponder;
import org.apache.axis2.transport.local.LocalResponseTransportOutDescription;
import org.apache.axis2.transport.local.LocalTransportSender;
import org.apache.axis2.util.MessageContextBuilder;

public class LocalTransportReceiver {
    public static ConfigurationContext CONFIG_CONTEXT;
    private ConfigurationContext confContext;
    private MessageContext inMessageContext;

    public LocalTransportReceiver(ConfigurationContext configContext) {
        this.confContext = configContext;
    }

    public LocalTransportReceiver(LocalTransportSender sender) {
        this(CONFIG_CONTEXT);
    }

    public void processMessage(MessageContext inMessageContext, InputStream in, OutputStream response) throws AxisFault {
        if (this.confContext == null) {
            this.confContext = inMessageContext.getConfigurationContext();
        }
        this.inMessageContext = inMessageContext;
        EndpointReference to = inMessageContext.getTo();
        String action = inMessageContext.getOptions().getAction();
        this.processMessage(in, to, action, response);
    }

    public void processMessage(ConfigurationContext configurationContext, InputStream in, EndpointReference to, String action, OutputStream response) throws AxisFault {
        if (this.confContext == null) {
            this.confContext = configurationContext;
        }
        this.processMessage(in, to, action, response);
    }

    public void processMessage(InputStream in, EndpointReference to, String action, OutputStream response) throws AxisFault {
        MessageContext msgCtx = this.confContext.createMessageContext();
        if (this.inMessageContext != null) {
            msgCtx.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, this.inMessageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST));
            msgCtx.setProperty("REMOTE_ADDR", this.inMessageContext.getProperty("REMOTE_ADDR"));
        }
        TransportInDescription tIn = this.confContext.getAxisConfiguration().getTransportIn("local");
        TransportOutDescription tOut = this.confContext.getAxisConfiguration().getTransportOut("local");
        LocalResponseTransportOutDescription localTransportResOut = new LocalResponseTransportOutDescription(tOut);
        localTransportResOut.setSender(new LocalResponder(response));
        try {
            msgCtx.setIncomingTransportName("local");
            msgCtx.setTransportIn(tIn);
            msgCtx.setTransportOut(localTransportResOut);
            msgCtx.setProperty("TRANSPORT_OUT", response);
            Object headers = this.inMessageContext.getProperty("TRANSPORT_HEADERS");
            if (headers != null) {
                msgCtx.setProperty("TRANSPORT_HEADERS", headers);
            }
            msgCtx.setTo(to);
            msgCtx.setWSAAction(action);
            msgCtx.setServerSide(true);
            InputStreamReader streamReader = new InputStreamReader(in);
            SOAPEnvelope envelope = OMXMLBuilderFactory.createSOAPModelBuilder((Reader)streamReader).getSOAPEnvelope();
            msgCtx.setEnvelope(envelope);
            AxisEngine.receive(msgCtx);
        }
        catch (AxisFault e) {
            MessageContext faultContext = MessageContextBuilder.createFaultMessageContext(msgCtx, e);
            faultContext.setTransportOut(localTransportResOut);
            faultContext.setProperty("TRANSPORT_OUT", response);
            AxisEngine.sendFault(faultContext);
        }
    }
}

