/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.xml.namespace.QName;
import org.apache.axiom.mime.ContentType;
import org.apache.axiom.mime.Header;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.NamedValue;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.kernel.MessageFormatter;
import org.apache.axis2.kernel.http.HTTPConstants;
import org.apache.axis2.transport.http.AxisRequestEntity;
import org.apache.axis2.transport.http.CommonsTransportHeaders;
import org.apache.axis2.transport.http.HTTPAuthenticator;
import org.apache.axis2.transport.http.Request;
import org.apache.axis2.util.MessageProcessorSelector;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class HTTPSender {
    private static final Log log = LogFactory.getLog(HTTPSender.class);
    private boolean chunked = false;
    private String httpVersion = "HTTP/1.1";
    protected TransportOutDescription proxyOutSetting = null;
    protected OMOutputFormat format = new OMOutputFormat();

    public void setChunked(boolean chunked) {
        this.chunked = chunked;
    }

    public void setHttpVersion(String version) throws AxisFault {
        if (version != null) {
            if ("HTTP/1.1".equals(version)) {
                this.httpVersion = "HTTP/1.1";
            } else if ("HTTP/1.0".equals(version)) {
                this.httpVersion = "HTTP/1.0";
                this.chunked = false;
            } else {
                throw new AxisFault("Parameter PROTOCOL Can have values only HTTP/1.0 or HTTP/1.1");
            }
        }
    }

    public void setFormat(OMOutputFormat format) {
        this.format = format;
    }

    protected abstract Request createRequest(MessageContext var1, String var2, URL var3, AxisRequestEntity var4) throws AxisFault;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(MessageContext msgContext, URL url, String soapActionString) throws IOException {
        Object cookieString;
        boolean gzip;
        AxisRequestEntity requestEntity;
        HTTPAuthenticator authenticator;
        String httpMethod = (String)msgContext.getProperty("HTTP_METHOD");
        if (httpMethod == null) {
            httpMethod = "POST";
        }
        MessageFormatter messageFormatter = MessageProcessorSelector.getMessageFormatter(msgContext);
        url = messageFormatter.getTargetAddress(msgContext, this.format, url);
        String contentType = messageFormatter.getContentType(msgContext, this.format, soapActionString);
        Object obj = msgContext.getProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_");
        if (obj == null) {
            authenticator = null;
        } else if (obj instanceof HTTPAuthenticator) {
            authenticator = (HTTPAuthenticator)obj;
        } else {
            throw new AxisFault("HttpTransportProperties.Authenticator class cast exception");
        }
        if ("GET".equalsIgnoreCase(httpMethod) || "DELETE".equalsIgnoreCase(httpMethod)) {
            requestEntity = null;
            gzip = false;
        } else if ("POST".equalsIgnoreCase(httpMethod) || "PUT".equalsIgnoreCase(httpMethod)) {
            gzip = msgContext.isPropertyTrue("transport.http.gzipRequest");
            requestEntity = new AxisRequestEntity(messageFormatter, msgContext, this.format, contentType, this.chunked, gzip, authenticator != null && authenticator.isAllowedRetry());
        } else {
            throw new AxisFault("Unsupported HTTP method " + httpMethod);
        }
        Request request = this.createRequest(msgContext, httpMethod, url, requestEntity);
        if (msgContext.getOptions() != null && msgContext.getOptions().isManageSession() && (cookieString = msgContext.getProperty("Cookie")) != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(cookieString);
            request.setHeader("Cookie", buffer.toString());
        }
        if (this.httpVersion.equals("HTTP/1.0")) {
            request.enableHTTP10();
        }
        request.setHeader("Content-Type", contentType);
        String soapAction = messageFormatter.formatSOAPAction(msgContext, this.format, soapActionString);
        if (soapAction != null && !msgContext.isDoingREST()) {
            request.setHeader("SOAPAction", soapAction);
        }
        if (gzip) {
            request.setHeader("Content-Encoding", "gzip");
        }
        this.addCustomHeaders(msgContext, request);
        if (authenticator != null) {
            request.enableAuthentication(authenticator);
        }
        this.setTimeouts(msgContext, request);
        try {
            request.execute();
            boolean cleanup = true;
            try {
                boolean fault;
                boolean processResponse;
                int statusCode = request.getStatusCode();
                log.trace((Object)("Handling response - " + statusCode));
                if (statusCode == 202) {
                    processResponse = false;
                    fault = false;
                } else if (statusCode >= 200 && statusCode < 300) {
                    processResponse = true;
                    fault = false;
                } else if (statusCode == 500 || statusCode == 400 || statusCode == 404) {
                    processResponse = true;
                    fault = true;
                } else {
                    throw new AxisFault(Messages.getMessage("transportError", String.valueOf(statusCode), request.getStatusText()));
                }
                this.obtainHTTPHeaderInformation(request, msgContext);
                if (processResponse) {
                    InputStream in;
                    MessageContext inMessageContext;
                    OperationContext opContext = msgContext.getOperationContext();
                    MessageContext messageContext = inMessageContext = opContext == null ? null : opContext.getMessageContext("In");
                    if (opContext != null && (in = request.getResponseContent()) != null) {
                        String contentEncoding = request.getResponseHeader("Content-Encoding");
                        if (contentEncoding != null) {
                            if (contentEncoding.equalsIgnoreCase("gzip")) {
                                in = new GZIPInputStream(in);
                            } else if (!"identity".equalsIgnoreCase(contentEncoding)) {
                                throw new AxisFault("HTTP :unsupported content-encoding of '" + contentEncoding + "' found");
                            }
                        }
                        opContext.setProperty("TRANSPORT_IN", in);
                        if (msgContext.isPropertyTrue("AutoReleaseConnection")) {
                            log.debug((Object)"AUTO_RELEASE_CONNECTION enabled; are you sure that you really want that?");
                        } else {
                            cleanup = false;
                        }
                    }
                    if (fault) {
                        if (inMessageContext != null) {
                            inMessageContext.setProcessingFault(true);
                        }
                        if (Utils.isClientThreadNonBlockingPropertySet(msgContext)) {
                            throw new AxisFault(Messages.getMessage("transportError", String.valueOf(statusCode), request.getStatusText()));
                        }
                    }
                }
            }
            finally {
                if (cleanup) {
                    request.releaseConnection();
                }
            }
        }
        catch (IOException e) {
            log.info((Object)("Unable to send to url[" + url + "]"), (Throwable)e);
            throw AxisFault.makeFault(e);
        }
    }

    private void addCustomHeaders(MessageContext msgContext, Request request) {
        Map transportHeaders;
        boolean isCustomUserAgentSet = false;
        Object httpHeadersObj = msgContext.getProperty("HTTP_HEADERS");
        if (httpHeadersObj != null) {
            Object httpHeaders;
            if (httpHeadersObj instanceof List) {
                httpHeaders = (List)httpHeadersObj;
                for (int i = 0; i < httpHeaders.size(); ++i) {
                    NamedValue nv = (NamedValue)httpHeaders.get(i);
                    if (nv == null) continue;
                    if ("User-Agent".equals(nv.getName())) {
                        isCustomUserAgentSet = true;
                    }
                    request.addHeader(nv.getName(), nv.getValue());
                }
            }
            if (httpHeadersObj instanceof Map) {
                httpHeaders = (Map)httpHeadersObj;
                for (Map.Entry entry : httpHeaders.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if ("User-Agent".equals(key)) {
                        isCustomUserAgentSet = true;
                    }
                    request.addHeader(key, value);
                }
            }
        }
        if ((transportHeaders = (Map)msgContext.getProperty("TRANSPORT_HEADERS")) != null) {
            this.removeUnwantedHeaders(msgContext);
            Set headerEntries = transportHeaders.entrySet();
            for (Map.Entry headerEntry : headerEntries) {
                if (!(headerEntry instanceof Map.Entry)) continue;
                Header[] headers = request.getRequestHeaders();
                boolean headerAdded = false;
                for (Header header : headers) {
                    if (header.getName() == null || !header.getName().equals(headerEntry.getKey())) continue;
                    headerAdded = true;
                    break;
                }
                if (headerAdded) continue;
                request.addHeader(headerEntry.getKey().toString(), headerEntry.getValue().toString());
            }
        }
        if (!isCustomUserAgentSet) {
            String userAgentString = this.getUserAgent(msgContext);
            request.setHeader("User-Agent", userAgentString);
        }
    }

    private void removeUnwantedHeaders(MessageContext msgContext) {
        Map headers = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
        if (headers == null || headers.isEmpty()) {
            return;
        }
        Iterator iter = headers.keySet().iterator();
        while (iter.hasNext()) {
            String headerName = (String)iter.next();
            if (!"Connection".equalsIgnoreCase(headerName) && !"Transfer-Encoding".equalsIgnoreCase(headerName) && !"Date".equalsIgnoreCase(headerName) && !"Content-Type".equalsIgnoreCase(headerName) && !"Content-Length".equalsIgnoreCase(headerName)) continue;
            iter.remove();
        }
    }

    private String getUserAgent(MessageContext messageContext) {
        String userAgentString = "Axis2";
        boolean locked = false;
        if (messageContext.getParameter("userAgent") != null) {
            OMElement userAgentElement = messageContext.getParameter("userAgent").getParameterElement();
            userAgentString = userAgentElement.getText().trim();
            OMAttribute lockedAttribute = userAgentElement.getAttribute(new QName("locked"));
            if (lockedAttribute != null && lockedAttribute.getAttributeValue().equalsIgnoreCase("true")) {
                locked = true;
            }
        }
        if (!locked && messageContext.getProperty("userAgent") != null) {
            userAgentString = (String)messageContext.getProperty("userAgent");
        }
        return userAgentString;
    }

    private void setTimeouts(MessageContext msgContext, Request request) {
        Integer tempSoTimeoutProperty = (Integer)msgContext.getProperty("SO_TIMEOUT");
        Integer tempConnTimeoutProperty = (Integer)msgContext.getProperty("CONNECTION_TIMEOUT");
        long timeout = msgContext.getOptions().getTimeOutInMilliSeconds();
        if (tempConnTimeoutProperty != null) {
            request.setConnectionTimeout(tempConnTimeoutProperty);
        }
        if (tempSoTimeoutProperty != null) {
            request.setSocketTimeout(tempSoTimeoutProperty);
        } else if (timeout > 0L) {
            request.setSocketTimeout((int)timeout);
        }
    }

    private void obtainHTTPHeaderInformation(Request request, MessageContext msgContext) throws AxisFault {
        Map<String, String> cookies;
        msgContext.setProperty("TRANSPORT_HEADERS", new CommonsTransportHeaders(request.getResponseHeaders()));
        msgContext.setProperty(HTTPConstants.MC_HTTP_STATUS_CODE, new Integer(request.getStatusCode()));
        String contentTypeString = request.getResponseHeader("Content-Type");
        if (contentTypeString != null) {
            ContentType contentType;
            try {
                contentType = new ContentType(contentTypeString);
            }
            catch (ParseException ex) {
                throw AxisFault.makeFault(ex);
            }
            String charSetEnc = contentType.getParameter(HTTPConstants.CHAR_SET_ENCODING);
            MessageContext inMessageContext = msgContext.getOperationContext().getMessageContext("In");
            if (inMessageContext != null) {
                inMessageContext.setProperty("ContentType", contentTypeString);
                inMessageContext.setProperty("CHARACTER_SET_ENCODING", charSetEnc);
            } else {
                HashMap<String, String> transportInfoMap = new HashMap<String, String>();
                transportInfoMap.put("ContentType", contentTypeString);
                transportInfoMap.put("CHARACTER_SET_ENCODING", charSetEnc);
                msgContext.setProperty("TransportInfoMap", transportInfoMap);
            }
        }
        if ((cookies = request.getCookies()) != null) {
            String customCookieId = (String)msgContext.getProperty("customCookieID");
            String cookieString = null;
            if (customCookieId != null) {
                cookieString = this.buildCookieString(cookies, customCookieId);
            }
            if (cookieString == null) {
                cookieString = this.buildCookieString(cookies, "axis_session");
            }
            if (cookieString == null) {
                cookieString = this.buildCookieString(cookies, "JSESSIONID");
            }
            if (cookieString != null) {
                msgContext.getServiceContext().setProperty("Cookie", cookieString);
            }
        }
    }

    private String buildCookieString(Map<String, String> cookies, String name) {
        String value = cookies.get(name);
        return value == null ? null : name + "=" + value;
    }
}

