/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.axiom.blob.Blobs;
import org.apache.axiom.blob.MemoryBlob;
import org.apache.axiom.blob.MemoryBlobOutputStream;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;

public final class AxisRequestEntity {
    private MessageFormatter messageFormatter;
    private final boolean chunked;
    private final boolean gzip;
    private MessageContext messageContext;
    private final MemoryBlob content;
    private final boolean preserve;
    private OMOutputFormat format;
    private final String contentType;

    AxisRequestEntity(MessageFormatter messageFormatter, MessageContext msgContext, OMOutputFormat format, String contentType, boolean chunked, boolean gzip, boolean preserve) throws AxisFault {
        this.messageFormatter = messageFormatter;
        this.messageContext = msgContext;
        this.chunked = chunked;
        this.gzip = gzip;
        this.preserve = preserve;
        this.format = format;
        this.contentType = contentType;
        if (chunked) {
            this.content = null;
        } else {
            this.content = Blobs.createMemoryBlob();
            MemoryBlobOutputStream out = this.content.getOutputStream();
            try {
                this.internalWriteRequest((OutputStream)out);
                out.close();
            }
            catch (IOException ex) {
                throw AxisFault.makeFault(ex);
            }
        }
    }

    public boolean isRepeatable() {
        return this.preserve || !this.chunked;
    }

    public void writeRequest(OutputStream outStream) throws IOException {
        if (this.chunked) {
            this.internalWriteRequest(outStream);
        } else {
            this.content.writeTo(outStream);
        }
    }

    private void internalWriteRequest(OutputStream outStream) throws IOException {
        if (this.gzip) {
            outStream = new GZIPOutputStream(outStream);
        }
        try {
            this.messageFormatter.writeTo(this.messageContext, this.format, outStream, this.preserve);
            if (this.gzip) {
                ((GZIPOutputStream)outStream).finish();
            }
            outStream.flush();
        }
        catch (IOException e) {
            throw AxisFault.makeFault(e);
        }
    }

    public long getContentLength() {
        if (this.chunked) {
            return -1L;
        }
        return this.content.getSize();
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isChunked() {
        return this.chunked;
    }
}

