/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.xml.stream.FactoryConfigurationError;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.NamedValue;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.HTTPSender;
import org.apache.axis2.transport.http.HTTPTransportSender;
import org.apache.axis2.transport.http.ServletBasedOutTransportInfo;
import org.apache.axis2.transport.http.server.AxisHttpResponse;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.MessageProcessorSelector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractHTTPTransportSender
extends AbstractHandler
implements HTTPTransportSender {
    private TransportOutDescription transportOut;
    private static final Log log = LogFactory.getLog(AbstractHTTPTransportSender.class);
    private String defaultHttpVersion = "HTTP/1.1";
    private boolean defaultChunked = false;
    private int soTimeout = 60000;
    private int connectionTimeout = 60000;

    @Override
    public void init(ConfigurationContext confContext, TransportOutDescription transportOut) throws AxisFault {
        this.transportOut = transportOut;
        this.setHTTPClientVersion(confContext);
        Parameter version = transportOut.getParameter("PROTOCOL");
        if (version != null) {
            if ("HTTP/1.1".equals(version.getValue())) {
                this.defaultHttpVersion = "HTTP/1.1";
                Parameter transferEncoding = transportOut.getParameter(HTTPConstants.HEADER_TRANSFER_ENCODING);
                if (transferEncoding != null && HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED.equals(transferEncoding.getValue())) {
                    this.defaultChunked = true;
                }
            } else if ("HTTP/1.0".equals(version.getValue())) {
                this.defaultHttpVersion = "HTTP/1.0";
            } else {
                throw new AxisFault("Parameter PROTOCOL Can have values only HTTP/1.0 or HTTP/1.1");
            }
        }
        try {
            Parameter tempSoTimeoutParam = transportOut.getParameter("SO_TIMEOUT");
            Parameter tempConnTimeoutParam = transportOut.getParameter("CONNECTION_TIMEOUT");
            if (tempSoTimeoutParam != null) {
                this.soTimeout = Integer.parseInt((String)tempSoTimeoutParam.getValue());
            }
            if (tempConnTimeoutParam != null) {
                this.connectionTimeout = Integer.parseInt((String)tempConnTimeoutParam.getValue());
            }
        }
        catch (NumberFormatException nfe) {
            log.error((Object)"Invalid timeout value format: not a number", (Throwable)nfe);
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        block17: {
            try {
                OMOutputFormat format = new OMOutputFormat();
                msgContext.setDoingMTOM(TransportUtils.doWriteMTOM(msgContext));
                msgContext.setDoingSwA(TransportUtils.doWriteSwA(msgContext));
                msgContext.setDoingREST(TransportUtils.isDoingREST(msgContext));
                format.setSOAP11(msgContext.isSOAP11());
                format.setDoOptimize(msgContext.isDoingMTOM());
                format.setDoingSWA(msgContext.isDoingSwA());
                format.setCharSetEncoding(TransportUtils.getCharSetEncoding(msgContext));
                Object mimeBoundaryProperty = msgContext.getProperty("mimeBoundary");
                if (mimeBoundaryProperty != null) {
                    format.setMimeBoundary((String)mimeBoundaryProperty);
                }
                if (msgContext.getProperty("SO_TIMEOUT") == null) {
                    msgContext.setProperty("SO_TIMEOUT", this.soTimeout);
                }
                if (msgContext.getProperty("CONNECTION_TIMEOUT") == null) {
                    msgContext.setProperty("CONNECTION_TIMEOUT", this.connectionTimeout);
                }
                if (!msgContext.isSOAP11()) {
                    Object propertyValue;
                    Parameter param = this.transportOut.getParameter("OmitSOAP12Action");
                    Object parameterValue = null;
                    if (param != null) {
                        parameterValue = param.getValue();
                    }
                    if (parameterValue != null && JavaUtils.isTrueExplicitly(parameterValue) && ((propertyValue = msgContext.getProperty("disableSoapAction")) == null || !JavaUtils.isFalseExplicitly(propertyValue))) {
                        msgContext.setProperty("disableSoapAction", Boolean.TRUE);
                    }
                }
                EndpointReference epr = null;
                String transportURL = (String)msgContext.getProperty("TransportURL");
                if (transportURL != null) {
                    epr = new EndpointReference(transportURL);
                } else if (msgContext.getTo() != null && !msgContext.getTo().hasAnonymousAddress()) {
                    epr = msgContext.getTo();
                }
                if (epr != null) {
                    if (!epr.hasNoneAddress()) {
                        this.writeMessageWithCommons(msgContext, epr, format);
                    } else if (msgContext.isFault() && log.isDebugEnabled()) {
                        log.debug((Object)("Fault sent to WS-A None URI: " + msgContext.getEnvelope().getBody().getFault()));
                    }
                    break block17;
                }
                if (msgContext.getProperty("TRANSPORT_OUT") != null) {
                    this.sendUsingOutputStream(msgContext, format);
                    TransportUtils.setResponseWritten(msgContext, true);
                    break block17;
                }
                throw new AxisFault("Both the TO and MessageContext.TRANSPORT_OUT property are null, so nowhere to send");
            }
            catch (FactoryConfigurationError e) {
                log.debug((Object)e);
                throw AxisFault.makeFault(e);
            }
            catch (IOException e) {
                log.debug((Object)e);
                throw AxisFault.makeFault(e);
            }
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void sendUsingOutputStream(MessageContext msgContext, OMOutputFormat format) throws AxisFault {
        block23: {
            MessageFormatter messageFormatter;
            Object customHeaders;
            OutputStream out = (OutputStream)msgContext.getProperty("TRANSPORT_OUT");
            OutTransportInfo transportInfo = (OutTransportInfo)msgContext.getProperty("OutTransportInfo");
            if (transportInfo == null) {
                throw new AxisFault("No transport info in MessageContext");
            }
            ServletBasedOutTransportInfo servletBasedOutTransportInfo = null;
            if (transportInfo instanceof ServletBasedOutTransportInfo) {
                servletBasedOutTransportInfo = (ServletBasedOutTransportInfo)transportInfo;
                if (msgContext.isFault()) {
                    servletBasedOutTransportInfo.setStatus(500);
                }
                if ((customHeaders = msgContext.getProperty("HTTP_HEADERS")) != null) {
                    if (customHeaders instanceof List) {
                        for (NamedValue namedValue : (List)customHeaders) {
                            if (namedValue == null) continue;
                            servletBasedOutTransportInfo.addHeader(namedValue.getName(), namedValue.getValue());
                        }
                    } else if (customHeaders instanceof Map) {
                        for (Map.Entry entry : ((Map)customHeaders).entrySet()) {
                            if (entry == null) continue;
                            servletBasedOutTransportInfo.addHeader((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                }
            } else if (transportInfo instanceof AxisHttpResponse && (customHeaders = msgContext.getProperty("HTTP_HEADERS")) != null) {
                if (customHeaders instanceof List) {
                    for (NamedValue namedValue : (List)customHeaders) {
                        if (namedValue == null) continue;
                        ((AxisHttpResponse)((Object)transportInfo)).addHeader(namedValue.getName(), namedValue.getValue());
                    }
                } else if (customHeaders instanceof Map) {
                    for (Map.Entry entry : ((Map)customHeaders).entrySet()) {
                        if (entry == null) continue;
                        ((AxisHttpResponse)((Object)transportInfo)).addHeader((String)entry.getKey(), (String)entry.getValue());
                    }
                }
            }
            if ((messageFormatter = MessageProcessorSelector.getMessageFormatter(msgContext)) == null) {
                throw new AxisFault("No MessageFormatter in MessageContext");
            }
            try {
                transportInfo.setContentType(messageFormatter.getContentType(msgContext, format, AbstractHTTPTransportSender.findSOAPAction(msgContext)));
                Object gzip = msgContext.getOptions().getProperty("gzipResponse");
                if (gzip != null && JavaUtils.isTrueExplicitly(gzip)) {
                    if (servletBasedOutTransportInfo != null) {
                        servletBasedOutTransportInfo.addHeader("Content-Encoding", "gzip");
                    }
                    try {
                        out = new GZIPOutputStream(out);
                        messageFormatter.writeTo(msgContext, format, out, false);
                        ((GZIPOutputStream)out).finish();
                        out.flush();
                        break block23;
                    }
                    catch (IOException iOException) {
                        throw new AxisFault("Could not compress response");
                    }
                }
                messageFormatter.writeTo(msgContext, format, out, false);
            }
            catch (AxisFault axisFault) {
                log.error((Object)axisFault.getMessage(), (Throwable)axisFault);
                throw axisFault;
            }
        }
    }

    private void writeMessageWithCommons(MessageContext messageContext, EndpointReference toEPR, OMOutputFormat format) throws AxisFault {
        try {
            URL url = new URL(toEPR.getAddress());
            HTTPSender sender = this.createHTTPSender();
            String httpVersion = messageContext.getProperty("__HTTP_PROTOCOL_VERSION__") != null ? (String)messageContext.getProperty("__HTTP_PROTOCOL_VERSION__") : this.defaultHttpVersion;
            boolean chunked = httpVersion.equals("HTTP/1.0") ? false : (messageContext.getProperty("__CHUNKED__") != null ? JavaUtils.isTrueExplicitly(messageContext.getProperty("__CHUNKED__")) : this.defaultChunked);
            sender.setChunked(chunked);
            sender.setHttpVersion(httpVersion);
            sender.setFormat(format);
            sender.send(messageContext, url, AbstractHTTPTransportSender.findSOAPAction(messageContext));
        }
        catch (MalformedURLException e) {
            log.debug((Object)e);
            throw AxisFault.makeFault(e);
        }
        catch (IOException e) {
            log.debug((Object)e);
            throw AxisFault.makeFault(e);
        }
    }

    protected abstract HTTPSender createHTTPSender();

    public static boolean isGeneratedName(String actionString) {
        if (actionString == null) {
            return false;
        }
        return actionString.indexOf("anon") >= 0 && (actionString.equals("anonOutInOp") || actionString.endsWith(":anonOutInOp") || actionString.endsWith("/anonOutInOp") || actionString.endsWith("}anonOutInOp") || actionString.equals("anonOutonlyOp") || actionString.endsWith(":anonOutonlyOp") || actionString.endsWith("/anonOutonlyOp") || actionString.endsWith("}anonOutonlyOp") || actionString.equals("anonRobustOp") || actionString.endsWith(":anonRobustOp") || actionString.endsWith("/anonRobustOp") || actionString.endsWith("}anonRobustOp"));
    }

    private static String findSOAPAction(MessageContext messageContext) {
        String soapActionString = null;
        Parameter parameter = messageContext.getTransportOut().getParameter("OmitSOAP12Action");
        if (parameter != null && JavaUtils.isTrueExplicitly(parameter.getValue()) && !messageContext.isSOAP11()) {
            return "\"\"";
        }
        Object disableSoapAction = messageContext.getOptions().getProperty("disableSoapAction");
        if (!JavaUtils.isTrueExplicitly(disableSoapAction)) {
            soapActionString = messageContext.getSoapAction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("SOAP Action from messageContext : (" + soapActionString + ")"));
            }
            if (AbstractHTTPTransportSender.isGeneratedName(soapActionString)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Will not use SOAP Action because (" + soapActionString + ") was auto-generated"));
                }
                soapActionString = null;
            }
            if (soapActionString == null || soapActionString.length() == 0) {
                soapActionString = messageContext.getWSAAction();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SOAP Action from getWSAAction was : (" + soapActionString + ")"));
                }
                if (messageContext.getAxisOperation() != null && (soapActionString == null || soapActionString.length() == 0)) {
                    String axisOpSOAPAction = messageContext.getAxisOperation().getSoapAction();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("SOAP Action from AxisOperation was : (" + axisOpSOAPAction + ")"));
                    }
                    if (AbstractHTTPTransportSender.isGeneratedName(axisOpSOAPAction)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Will not override SOAP Action because (" + axisOpSOAPAction + ") in AxisOperation was auto-generated"));
                        }
                    } else {
                        soapActionString = axisOpSOAPAction;
                    }
                }
            }
        }
        if (soapActionString == null && messageContext.isSOAP11()) {
            soapActionString = "\"\"";
        }
        return soapActionString;
    }

    @Override
    public void setHTTPClientVersion(ConfigurationContext configurationContext) {
        configurationContext.setProperty("http.client.version", "http.client.version.3x");
    }
}

