/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.osgi.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.AxisConfigBuilder;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.osgi.framework.BundleContext;

public class OSGiServerConfigurator
extends DeploymentEngine
implements AxisConfigurator {
    private BundleContext context;
    private URL axis2XmlUrl;

    public OSGiServerConfigurator(BundleContext context) {
        this.context = context;
        Enumeration entries = this.context.getBundle().findEntries("org/apache/axis2/osgi/deployment", "axis2.xml", false);
        if (entries != null && entries.hasMoreElements()) {
            this.axis2XmlUrl = (URL)entries.nextElement();
        }
    }

    @Override
    public AxisConfiguration getAxisConfiguration() throws AxisFault {
        try {
            InputStream inputStream = this.axis2XmlUrl.openStream();
            this.populateAxisConfiguration(inputStream);
            this.axisConfig.validateSystemPredefinedPhases();
            return this.axisConfig;
        }
        catch (IOException e) {
            String msg = "Error occured while creating axisConfiguration";
            throw new AxisFault(msg, e);
        }
    }

    @Override
    public void engageGlobalModules() throws AxisFault {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AxisConfiguration populateAxisConfiguration(InputStream in) throws DeploymentException {
        Thread currentThread = Thread.currentThread();
        ClassLoader savedTCCL = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(OSGiServerConfigurator.class.getClassLoader());
        try {
            this.axisConfig = new AxisConfiguration();
            AxisConfigBuilder builder = new AxisConfigBuilder(in, this.axisConfig, this);
            builder.populateConfig();
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                String msg = "Error in closing input stream";
                throw new DeploymentException(msg, e);
            }
            AxisConfiguration axisConfiguration = this.axisConfig;
            return axisConfiguration;
        }
        finally {
            currentThread.setContextClassLoader(savedTCCL);
        }
    }

    @Override
    public void loadServices() {
    }
}

