/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.osgi.deployment;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.ServiceGroupBuilder;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.osgi.deployment.AbstractRegistry;
import org.apache.axis2.osgi.deployment.BundleClassLoader;
import org.apache.axis2.osgi.deployment.OSGiAxis2Constants;
import org.apache.axis2.osgi.deployment.OSGiServiceBuilder;
import org.apache.axis2.osgi.deployment.OSGiServiceGroupBuilder;
import org.apache.axis2.osgi.deployment.Registry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceRegistry
extends AbstractRegistry<AxisServiceGroup> {
    private static Log log = LogFactory.getLog(ServiceRegistry.class);

    public ServiceRegistry(BundleContext context, ConfigurationContext configCtx) {
        super(context, configCtx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Bundle bundle) {
        this.lock.lock();
        try {
            this.addServices(bundle);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void addServices(Bundle bundle) {
        if (!this.resolvedBundles.containsKey(bundle)) {
            Enumeration enumeration = bundle.findEntries("META-INF", "*services.xml", false);
            int i = 0;
            ArrayList<AxisServiceGroup> axisServiceGroupList = null;
            if (enumeration != null) {
                axisServiceGroupList = new ArrayList<AxisServiceGroup>();
            }
            while (enumeration != null && enumeration.hasMoreElements()) {
                try {
                    URL url = (URL)enumeration.nextElement();
                    AxisServiceGroup serviceGroup = new AxisServiceGroup(this.configCtx.getAxisConfiguration());
                    serviceGroup.addParameter("last.updated", bundle.getLastModified());
                    BundleClassLoader loader = new BundleClassLoader(bundle, Registry.class.getClassLoader());
                    serviceGroup.setServiceGroupClassLoader(loader);
                    InputStream inputStream = url.openStream();
                    DescriptionBuilder builder = new DescriptionBuilder(inputStream, this.configCtx);
                    OMElement rootElement = builder.buildOM();
                    String elementName = rootElement.getLocalName();
                    Dictionary headers = bundle.getHeaders();
                    String bundleSymbolicName = (String)headers.get("Bundle-SymbolicName");
                    bundleSymbolicName = bundleSymbolicName + "_" + i;
                    serviceGroup.setServiceGroupName(bundleSymbolicName);
                    HashMap<String, AxisService> wsdlServicesMap = new HashMap<String, AxisService>();
                    if ("service".equals(elementName)) {
                        AxisService axisService = new AxisService(bundleSymbolicName);
                        axisService.setParent(serviceGroup);
                        axisService.setClassLoader(loader);
                        OSGiServiceBuilder serviceBuilder = new OSGiServiceBuilder(this.configCtx, axisService);
                        serviceBuilder.setWsdlServiceMap(wsdlServicesMap);
                        AxisService service = serviceBuilder.populateService(rootElement);
                        ArrayList<AxisService> serviceList = new ArrayList<AxisService>();
                        serviceList.add(service);
                        DeploymentEngine.addServiceGroup(serviceGroup, serviceList, null, null, this.configCtx.getAxisConfiguration());
                        log.info((Object)("[Axis2/OSGi] Deployed axis2 service:" + service.getName() + " in Bundle: " + bundle.getSymbolicName()));
                    } else if ("serviceGroup".equals(elementName)) {
                        OSGiServiceGroupBuilder groupBuilder = new OSGiServiceGroupBuilder(rootElement, wsdlServicesMap, this.configCtx);
                        ArrayList<AxisService> serviceList = ((ServiceGroupBuilder)groupBuilder).populateServiceGroup(serviceGroup);
                        DeploymentEngine.addServiceGroup(serviceGroup, serviceList, null, null, this.configCtx.getAxisConfiguration());
                        log.info((Object)("[Axis2/OSGi] Deployed axis2 service group:" + serviceGroup.getServiceGroupName() + " in Bundle: " + bundle.getSymbolicName()));
                    }
                    serviceGroup.addParameter(OSGiAxis2Constants.OSGi_BUNDLE_ID, bundle.getBundleId());
                    axisServiceGroupList.add(serviceGroup);
                    if (this.unreslovedBundles.contains(bundle)) {
                        this.unreslovedBundles.remove(bundle);
                    }
                    ++i;
                }
                catch (Throwable e) {
                    String msg = "Error while reading from the bundle";
                    if (e instanceof DeploymentException) {
                        String message = e.getMessage();
                        if (message != null && message.length() != 0) {
                            if (message.indexOf(OSGiAxis2Constants.MODULE_NOT_FOUND_ERROR) > -1) {
                                if (!this.unreslovedBundles.contains(bundle)) {
                                    log.info((Object)"A service being found with unmeant module dependency. Hence, moved it to UNRESOLVED state.");
                                    this.unreslovedBundles.add(bundle);
                                    continue;
                                }
                                log.info((Object)"A service being found in UNRESOLVED state.");
                                continue;
                            }
                            log.error((Object)msg, e);
                            break;
                        }
                        log.error((Object)msg, e);
                        break;
                    }
                    log.error((Object)msg, e);
                    break;
                }
            }
            if (axisServiceGroupList != null && axisServiceGroupList.size() > 0) {
                this.resolvedBundles.put(bundle, axisServiceGroupList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unRegister(Bundle bundle, boolean uninstall) {
        this.lock.lock();
        try {
            List axisServiceGroupList = (List)this.resolvedBundles.get(bundle);
            if (axisServiceGroupList != null) {
                for (AxisServiceGroup axisServiceGroup : axisServiceGroupList) {
                    if (this.resolvedBundles.containsKey(bundle)) {
                        this.resolvedBundles.remove(bundle);
                    }
                    if (!this.unreslovedBundles.contains(bundle) && !uninstall) {
                        this.unreslovedBundles.add(bundle);
                    }
                    try {
                        if (log.isInfoEnabled()) {
                            ArrayList<String> serviceNames = new ArrayList<String>();
                            Iterator<AxisService> iterator = axisServiceGroup.getServices();
                            while (iterator.hasNext()) {
                                AxisService service = iterator.next();
                                serviceNames.add(service.getName());
                            }
                            log.info((Object)("Stopping service group " + axisServiceGroup.getServiceGroupName() + " with services " + serviceNames + " in bundle " + bundle.getSymbolicName()));
                        }
                        this.configCtx.getAxisConfiguration().removeServiceGroup(axisServiceGroup.getServiceGroupName());
                    }
                    catch (AxisFault e) {
                        String msg = "Error while removing the service group";
                        log.error((Object)msg, (Throwable)e);
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Bundle bundle) {
        this.unRegister(bundle, true);
        this.lock.lock();
        try {
            if (this.resolvedBundles.containsKey(bundle)) {
                this.resolvedBundles.remove(bundle);
            }
            if (this.unreslovedBundles.contains(bundle)) {
                this.unreslovedBundles.remove(bundle);
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

