/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.osgi.internal;

import java.util.Hashtable;
import javax.servlet.Servlet;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.osgi.OSGiAxisServlet;
import org.apache.axis2.osgi.deployment.OSGiAxis2Constants;
import org.apache.axis2.osgi.deployment.OSGiConfigurationContextFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static Log log = LogFactory.getLog(Activator.class);
    private ConfigurationContextTracker tracker;
    private final OSGiConfigurationContextFactory managedService = new OSGiConfigurationContextFactory();

    public void start(BundleContext context) throws Exception {
        this.managedService.start(context);
        this.tracker = new ConfigurationContextTracker(context);
        this.tracker.open();
    }

    public void stop(BundleContext context) {
        this.tracker.close();
        this.managedService.stop();
    }

    class ConfigurationContextTracker
    extends ServiceTracker {
        public ConfigurationContextTracker(BundleContext context) {
            super(context, ConfigurationContext.class.getName(), null);
        }

        public Object addingService(ServiceReference serviceReference) {
            ConfigurationContext configCtx = (ConfigurationContext)this.context.getService(serviceReference);
            OSGiAxisServlet axisServlet = new OSGiAxisServlet(configCtx);
            String propServiceContextRoot = this.context.getProperty(OSGiAxis2Constants.AXIS2_OSGi_ROOT_CONTEXT);
            String serviceContextRoot = "services";
            if (propServiceContextRoot != null && propServiceContextRoot.length() != 0) {
                serviceContextRoot = propServiceContextRoot.startsWith("/") ? propServiceContextRoot.substring(1) : propServiceContextRoot;
            }
            configCtx.setServicePath(serviceContextRoot);
            String contextRoot = "/" + serviceContextRoot;
            log.info((Object)("Registering SOAP message listener servlet to context : " + contextRoot));
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("alias", contextRoot);
            return this.context.registerService(Servlet.class.getName(), (Object)axisServlet, props);
        }

        public void removedService(ServiceReference reference, Object service) {
            ((ServiceRegistration)service).unregister();
            this.context.ungetService(reference);
        }
    }
}

