/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.webapp;

import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.apache.axis2.webapp.ActionHandler;
import org.apache.axis2.webapp.CSRFTokenCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CSRFPreventionResponseWrapper
extends HttpServletResponseWrapper {
    private static final Log log = LogFactory.getLog(CSRFPreventionResponseWrapper.class);
    private final HttpServletRequest request;
    private final Map<String, ActionHandler> actionHandlers;
    private final Random random;
    private String token;

    CSRFPreventionResponseWrapper(HttpServletRequest request, HttpServletResponse response, Map<String, ActionHandler> actionHandlers, Random random) {
        super(response);
        this.request = request;
        this.actionHandlers = actionHandlers;
        this.random = random;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getToken() {
        if (this.token == null) {
            CSRFTokenCache tokenCache;
            HttpSession session = this.request.getSession(false);
            if (session == null) {
                throw new IllegalStateException();
            }
            HttpSession httpSession = session;
            synchronized (httpSession) {
                tokenCache = (CSRFTokenCache)session.getAttribute(CSRFTokenCache.class.getName());
                if (tokenCache == null) {
                    tokenCache = new CSRFTokenCache();
                    session.setAttribute(CSRFTokenCache.class.getName(), (Object)tokenCache);
                }
            }
            byte[] bytes = new byte[16];
            StringBuilder buffer = new StringBuilder();
            this.random.nextBytes(bytes);
            for (int j = 0; j < bytes.length; ++j) {
                byte b1 = (byte)((bytes[j] & 0xF0) >> 4);
                byte b2 = (byte)(bytes[j] & 0xF);
                if (b1 < 10) {
                    buffer.append((char)(48 + b1));
                } else {
                    buffer.append((char)(65 + (b1 - 10)));
                }
                if (b2 < 10) {
                    buffer.append((char)(48 + b2));
                    continue;
                }
                buffer.append((char)(65 + (b2 - 10)));
            }
            this.token = buffer.toString();
            tokenCache.add(this.token);
        }
        return this.token;
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeURL(String url) {
        int idx = url.indexOf(63);
        String path = idx == -1 ? url : url.substring(0, idx);
        String action = path.substring(path.lastIndexOf(47) + 1);
        ActionHandler actionHandler = (ActionHandler)this.actionHandlers.get(action);
        if (actionHandler == null) {
            log.warn((Object)("Unknown action: " + action));
        } else if (actionHandler.isCSRFTokenRequired()) {
            url = url + (idx == -1 ? (char)'?' : '&') + "token=" + this.getToken();
        }
        return super.encodeURL(url);
    }
}

