/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.xmpp;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterIncludeImpl;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.xmpp.util.XMPPConnectionFactory;
import org.apache.axis2.transport.xmpp.util.XMPPPacketListener;
import org.apache.axis2.transport.xmpp.util.XMPPServerCredentials;
import org.apache.axis2.util.threadpool.DefaultThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.XMPPConnection;

public class XMPPListener
implements TransportListener {
    private static Log log = LogFactory.getLog(XMPPListener.class);
    private ConfigurationContext configurationContext = null;
    private XMPPServerCredentials serverCredentials;
    private Map connectionFactories = new HashMap();
    private ExecutorService workerPool;
    private static final int WORKERS_MAX_THREADS = 5;
    private static final long WORKER_KEEP_ALIVE = 60L;
    private static final TimeUnit TIME_UNIT = TimeUnit.SECONDS;
    private XMPPConnection xmppConnection = null;

    public void init(ConfigurationContext configurationCtx, TransportInDescription transportIn) throws AxisFault {
        log.info((Object)"Initializing XMPPListener...");
        Roster.setDefaultSubscriptionMode((Roster.SubscriptionMode)Roster.SubscriptionMode.accept_all);
        this.configurationContext = configurationCtx;
        this.initializeConnectionFactories(transportIn);
        if (this.connectionFactories.isEmpty()) {
            log.warn((Object)"No XMPP connection factories defined.Will not listen for any XMPP messages");
            return;
        }
    }

    private void initializeConnectionFactories(TransportInDescription transportIn) throws AxisFault {
        for (Parameter connection : transportIn.getParameters()) {
            log.info((Object)("Trying to establish connection for : " + connection.getName()));
            ParameterIncludeImpl pi = new ParameterIncludeImpl();
            try {
                pi.deserializeParameters((OMElement)connection.getValue());
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Error reading parameters");
            }
            Iterator params = pi.getParameters().iterator();
            this.serverCredentials = new XMPPServerCredentials();
            while (params.hasNext()) {
                Parameter param = (Parameter)params.next();
                if ("transport.xmpp.ServerUrl".equals(param.getName())) {
                    this.serverCredentials.setServerUrl((String)param.getValue());
                    continue;
                }
                if ("transport.xmpp.ServerAccountUserName".equals(param.getName())) {
                    this.serverCredentials.setAccountName((String)param.getValue());
                    continue;
                }
                if ("transport.xmpp.ServerAccountPassword".equals(param.getName())) {
                    this.serverCredentials.setPassword((String)param.getValue());
                    continue;
                }
                if ("transport.xmpp.ServerType".equals(param.getName())) {
                    this.serverCredentials.setServerType((String)param.getValue());
                    continue;
                }
                if (!"transport.xmpp.domain".equals(param.getName())) continue;
                this.serverCredentials.setDomainName((String)param.getValue());
            }
            XMPPConnectionFactory xmppConnectionFactory = new XMPPConnectionFactory();
            xmppConnectionFactory.connect(this.serverCredentials);
            this.connectionFactories.put(this.serverCredentials.getAccountName() + "@" + this.serverCredentials.getServerUrl(), xmppConnectionFactory);
        }
    }

    public void stop() {
        if (this.workerPool != null && !this.workerPool.isShutdown()) {
            this.workerPool.shutdown();
        }
    }

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        return this.getEPRsForService(serviceName, ip)[0];
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        String domainName = this.serverCredentials.getDomainName() == null ? this.serverCredentials.getDomainName() : this.serverCredentials.getServerUrl();
        return new EndpointReference[]{new EndpointReference("xmpp://" + this.serverCredentials.getAccountName() + "@" + domainName + "/services/" + serviceName)};
    }

    public SessionContext getSessionContext(MessageContext messageContext) {
        return null;
    }

    public void destroy() {
        if (this.xmppConnection != null && this.xmppConnection.isConnected()) {
            this.xmppConnection.disconnect();
        }
    }

    public void start() throws AxisFault {
        ThreadPoolExecutor workerPool = new ThreadPoolExecutor(1, 5, 60L, TIME_UNIT, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new DefaultThreadFactory(new ThreadGroup("XMPP Worker thread group"), "XMPPWorker"));
        for (XMPPConnectionFactory connectionFactory : this.connectionFactories.values()) {
            XMPPPacketListener xmppPacketListener = new XMPPPacketListener(connectionFactory, this.configurationContext, workerPool);
            connectionFactory.listen(xmppPacketListener);
        }
    }
}

