/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.util.tcpmon;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.axis2.transport.testkit.util.tcpmon.Acceptor;

public class Tunnel {
    private final ServerSocket serverSocket = new ServerSocket(0);
    private final InetSocketAddress target;
    private ExecutorService executorService;

    public Tunnel(InetSocketAddress target) throws IOException {
        this.target = target;
    }

    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    public void start() {
        this.executorService = Executors.newCachedThreadPool();
        this.executorService.execute(new Acceptor(this.serverSocket, this.executorService, this.target));
    }

    public void stop() throws IOException {
        this.serverSocket.close();
        this.executorService.shutdown();
    }
}

