/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.util.tcpmon;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.axis2.transport.base.datagram.Utils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class Relay
implements Runnable {
    private static final Log log = LogFactory.getLog(Relay.class);
    private final Socket inSocket;
    private final InputStream in;
    private final OutputStream out;
    private final String connectionSpec;

    public Relay(Socket inSocket, Socket outSocket, boolean isResponse) throws IOException {
        this.inSocket = inSocket;
        this.in = inSocket.getInputStream();
        this.out = outSocket.getOutputStream();
        this.connectionSpec = isResponse ? outSocket.getRemoteSocketAddress() + " <- " + inSocket.getRemoteSocketAddress() : inSocket.getRemoteSocketAddress() + " -> " + outSocket.getRemoteSocketAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        byte[] buf = new byte[4096];
        try {
            int n;
            while ((n = this.in.read(buf)) > 0) {
                StringBuilder dump = new StringBuilder(this.connectionSpec);
                dump.append('\n');
                Utils.hexDump((StringBuilder)dump, (byte[])buf, (int)n);
                log.debug((Object)dump);
                this.out.write(buf, 0, n);
                this.out.flush();
            }
        }
        catch (IOException ex) {
            if (!this.inSocket.isClosed()) {
                log.error((Object)ex);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)this.in);
            IOUtils.closeQuietly((OutputStream)this.out);
        }
        log.debug((Object)(this.connectionSpec + ": closed"));
    }
}

