/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.util.tcpmon;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import org.apache.axis2.transport.testkit.util.tcpmon.Relay;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class Acceptor
implements Runnable {
    private static final Log log = LogFactory.getLog(Acceptor.class);
    private final ServerSocket serverSocket;
    private final ExecutorService executorService;
    private final InetSocketAddress target;

    public Acceptor(ServerSocket serverSocket, ExecutorService executorService, InetSocketAddress target) {
        this.serverSocket = serverSocket;
        this.executorService = executorService;
        this.target = target;
    }

    public void run() {
        while (true) {
            Socket socket;
            try {
                socket = this.serverSocket.accept();
            }
            catch (IOException ex) {
                break;
            }
            try {
                Socket targetSocket = new Socket(this.target.getAddress(), this.target.getPort());
                this.executorService.execute(new Relay(socket, targetSocket, false));
                this.executorService.execute(new Relay(targetSocket, socket, true));
            }
            catch (IOException ex) {
                log.error((Object)ex);
            }
        }
    }
}

