/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.util;

import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServerUtil {
    private static final Log log = LogFactory.getLog(ServerUtil.class);

    private ServerUtil() {
    }

    public static void waitForServer(int port) throws Exception {
        InetAddress localhost = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        int attempts = 0;
        Socket socket = null;
        while (socket == null) {
            ++attempts;
            try {
                socket = new Socket(localhost, port);
            }
            catch (ConnectException ex) {
                if (attempts < 10) {
                    Thread.sleep(50L);
                    continue;
                }
                throw ex;
            }
        }
        log.debug((Object)("Server on port " + port + " ready after " + attempts + " connection attempts"));
        socket.close();
    }
}

