/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.util;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.transport.testkit.tests.Setup;
import org.apache.axis2.transport.testkit.tests.TearDown;

public class PortAllocator {
    private static final int BASE_PORT = 9000;
    private static final int BASE_PORT_INCREMENT = 10;
    public static final PortAllocator INSTANCE = new PortAllocator();
    private int basePort;
    private List<PortRange> ranges;

    private PortAllocator() {
    }

    @Setup
    private void setUp() {
        this.basePort = 9000;
        this.ranges = new ArrayList<PortRange>();
    }

    @TearDown
    private void tearDown() throws Exception {
        for (PortRange range : this.ranges) {
            range.release();
        }
        this.ranges = null;
    }

    public synchronized int allocatePort() {
        ServerSocket serverSocket;
        PortRange range2;
        for (PortRange range2 : this.ranges) {
            int port = range2.allocatePort();
            if (port == -1) continue;
            return port;
        }
        do {
            try {
                serverSocket = new ServerSocket(this.basePort);
            }
            catch (IOException ex) {
                serverSocket = null;
            }
            this.basePort += 10;
        } while (serverSocket == null);
        range2 = new PortRange(serverSocket);
        this.ranges.add(range2);
        return range2.allocatePort();
    }

    public synchronized void releasePort(int port) {
        for (PortRange range : this.ranges) {
            if (!range.hasPort(port)) continue;
            range.releasePort(port);
            return;
        }
        throw new IllegalArgumentException("Invalid port number");
    }

    static class PortRange {
        private final ServerSocket serverSocket;
        private final int basePort;
        private final boolean[] allocated = new boolean[9];

        PortRange(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
            this.basePort = serverSocket.getLocalPort();
        }

        int allocatePort() {
            for (int i = 0; i < 9; ++i) {
                if (this.allocated[i]) continue;
                this.allocated[i] = true;
                return this.basePort + i + 1;
            }
            return -1;
        }

        boolean hasPort(int port) {
            return port > this.basePort && port < this.basePort + 10;
        }

        void releasePort(int port) {
            int i = port - this.basePort - 1;
            if (!this.allocated[i]) {
                throw new IllegalStateException("Port is not allocated");
            }
            this.allocated[i] = false;
        }

        void release() {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

