/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.tests.echo;

import javax.mail.internet.ContentType;
import org.apache.axis2.transport.testkit.channel.RequestResponseChannel;
import org.apache.axis2.transport.testkit.client.RequestResponseTestClient;
import org.apache.axis2.transport.testkit.endpoint.InOutEndpoint;
import org.apache.axis2.transport.testkit.tests.MessageTestCase;
import org.apache.axis2.transport.testkit.tests.echo.InterruptingEndpointErrorListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RequestResponseMessageTestCase<M, N>
extends MessageTestCase {
    private final RequestResponseTestClient<M, N> client;
    private final InOutEndpoint endpoint;

    public RequestResponseMessageTestCase(RequestResponseChannel channel, RequestResponseTestClient<M, N> client, InOutEndpoint endpoint, ContentType contentType, String charset, Object ... resources) {
        super(client, contentType, charset, resources);
        this.client = client;
        this.endpoint = endpoint;
        this.addResource(channel);
        this.addResource(endpoint);
    }

    @Override
    protected void doRunTest() throws Throwable {
        N response;
        M request = this.prepareRequest();
        InterruptingEndpointErrorListener listener = new InterruptingEndpointErrorListener(Thread.currentThread());
        this.endpoint.addEndpointErrorListener(listener);
        try {
            response = this.client.sendMessage(this.options, this.contentType, request).getData();
        }
        catch (Throwable ex) {
            if (listener.getException() != null) {
                throw listener.getException();
            }
            throw ex;
        }
        finally {
            this.endpoint.removeEndpointErrorListener(listener);
        }
        this.checkResponse(request, response);
    }

    protected abstract M prepareRequest() throws Exception;

    protected abstract void checkResponse(M var1, N var2) throws Exception;
}

