/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.tests.async;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Random;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.transport.testkit.channel.AsyncChannel;
import org.apache.axis2.transport.testkit.client.AsyncTestClient;
import org.apache.axis2.transport.testkit.endpoint.AsyncEndpoint;
import org.apache.axis2.transport.testkit.message.XMLMessage;
import org.apache.axis2.transport.testkit.name.Name;
import org.apache.axis2.transport.testkit.tests.async.AsyncMessageTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="AsyncSwA")
public class SwATestCase
extends AsyncMessageTestCase<XMLMessage> {
    private static final Random random = new Random();
    private byte[] attachmentContent;
    private String contentID;

    public SwATestCase(AsyncChannel channel, AsyncTestClient<XMLMessage> client, AsyncEndpoint<XMLMessage> endpoint, Object ... resources) {
        super(channel, client, endpoint, XMLMessage.Type.SWA.getContentType(), "UTF-8", resources);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.attachmentContent = new byte[8192];
        random.nextBytes(this.attachmentContent);
        this.contentID = UIDGenerator.generateContentId();
    }

    @Override
    protected XMLMessage prepareMessage() throws Exception {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement payload = factory.createOMElement(new QName("root"));
        Attachments attachments = new Attachments();
        attachments.addDataHandler(this.contentID, new DataHandler((DataSource)new ByteArrayDataSource(this.attachmentContent, "application/octet-stream")));
        return new XMLMessage(payload, XMLMessage.Type.SWA, attachments);
    }

    @Override
    protected void checkMessageData(XMLMessage expected, XMLMessage actual) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Attachments attachments = actual.getAttachments();
        DataHandler dataHandler = attachments.getDataHandler(this.contentID);
        SwATestCase.assertNotNull((Object)dataHandler);
        dataHandler.writeTo((OutputStream)baos);
        SwATestCase.assertTrue((boolean)Arrays.equals(this.attachmentContent, baos.toByteArray()));
    }
}

