/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.tests.async;

import javax.mail.internet.ContentType;
import org.apache.axis2.transport.testkit.channel.AsyncChannel;
import org.apache.axis2.transport.testkit.client.AsyncTestClient;
import org.apache.axis2.transport.testkit.endpoint.AsyncEndpoint;
import org.apache.axis2.transport.testkit.message.IncomingMessage;
import org.apache.axis2.transport.testkit.tests.MessageTestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsyncMessageTestCase<M>
extends MessageTestCase {
    private static final Log log = LogFactory.getLog(AsyncMessageTestCase.class);
    private final AsyncTestClient<M> client;
    private final AsyncEndpoint<M> endpoint;

    public AsyncMessageTestCase(AsyncChannel channel, AsyncTestClient<M> client, AsyncEndpoint<M> endpoint, ContentType contentType, String charset, Object ... resources) {
        super(client, contentType, charset, resources);
        this.client = client;
        this.endpoint = endpoint;
        this.addResource(channel);
        this.addResource(endpoint);
    }

    @Override
    protected void doRunTest() throws Throwable {
        this.endpoint.clear();
        log.debug((Object)"Preparing message");
        M expected = this.prepareMessage();
        log.debug((Object)"Sending message");
        this.client.sendMessage(this.options, this.contentType, expected);
        log.debug((Object)"Message sent; waiting for endpoint to receive message");
        IncomingMessage<M> actual = this.endpoint.waitForMessage(8000);
        if (actual == null) {
            log.debug((Object)"Message NOT received by endpoint; failing test");
            AsyncMessageTestCase.fail((String)"Failed to get message");
        }
        log.debug((Object)"Message received by endpoint; checking message data");
        this.checkMessageData(expected, actual.getData());
        log.debug((Object)"Message received by endpoint has expected content");
    }

    protected abstract M prepareMessage() throws Exception;

    protected abstract void checkMessageData(M var1, M var2) throws Exception;
}

