/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.tests;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.axis2.transport.testkit.Adapter;
import org.apache.axis2.transport.testkit.tests.Setup;
import org.apache.axis2.transport.testkit.tests.TearDown;
import org.apache.axis2.transport.testkit.tests.TestResourceSet;
import org.apache.axis2.transport.testkit.tests.Transient;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class TestResource {
    private final Object instance;
    private final Object target;
    private final Set<TestResource> directDependencies = new HashSet<TestResource>();
    private final LinkedList<Invocable> initializers = new LinkedList();
    private final List<Invocable> finalizers = new LinkedList<Invocable>();
    private Status status = Status.UNRESOLVED;
    private boolean hasHashCode;
    private int hashCode;

    public TestResource(Object instance) {
        this.instance = instance;
        Object target = instance;
        while (target instanceof Adapter) {
            target = ((Adapter)target).getTarget();
        }
        this.target = target;
    }

    public void resolve(TestResourceSet resourceSet) {
        if (this.status != Status.UNRESOLVED) {
            return;
        }
        Class<?> clazz = this.target.getClass();
        while (!clazz.equals(Object.class)) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (method.getAnnotation(Setup.class) != null) {
                    Type[] parameterTypes = method.getGenericParameterTypes();
                    Object[] args = new Object[parameterTypes.length];
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        Type parameterType = parameterTypes[i];
                        if (!(parameterType instanceof Class)) {
                            throw new Error("Generic parameters not supported in " + method);
                        }
                        Class parameterClass = (Class)parameterType;
                        if (parameterClass.isArray()) {
                            Class<?> componentType = parameterClass.getComponentType();
                            TestResource[] resources = resourceSet.findResources(componentType, true);
                            Object[] arg = (Object[])Array.newInstance(componentType, resources.length);
                            for (int j = 0; j < resources.length; ++j) {
                                TestResource resource = resources[j];
                                this.directDependencies.add(resource);
                                arg[j] = resource.getInstance();
                            }
                            args[i] = arg;
                            continue;
                        }
                        TestResource[] resources = resourceSet.findResources(parameterClass, true);
                        if (resources.length == 0) {
                            throw new Error(this.target.getClass().getName() + " depends on " + parameterClass.getName() + ", but none found");
                        }
                        if (resources.length > 1) {
                            throw new Error(this.target.getClass().getName() + " depends on " + parameterClass.getName() + ", but multiple candidates found");
                        }
                        TestResource resource = resources[0];
                        this.directDependencies.add(resource);
                        args[i] = resource.getInstance();
                    }
                    method.setAccessible(true);
                    this.initializers.addFirst(new MethodInvocation(method, args));
                    continue;
                }
                if (method.getAnnotation(TearDown.class) == null || method.getParameterTypes().length != 0) continue;
                method.setAccessible(true);
                this.finalizers.add(new MethodInvocation(method, null));
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                if (((Field)accessibleObject).getAnnotation(Transient.class) == null) continue;
                ((Field)accessibleObject).setAccessible(true);
                this.finalizers.add(new FieldResetter((Field)accessibleObject));
            }
            clazz = clazz.getSuperclass();
        }
        this.status = Status.RESOLVED;
    }

    public Object getInstance() {
        return this.instance;
    }

    public Object getTarget() {
        return this.target;
    }

    public boolean hasLifecycle() {
        return !this.initializers.isEmpty() || !this.finalizers.isEmpty();
    }

    public void setUp() throws Exception {
        if (this.status != Status.RESOLVED) {
            throw new IllegalStateException();
        }
        for (Invocable initializer : this.initializers) {
            initializer.execute(this.target);
        }
        this.status = Status.SETUP;
    }

    public void recycle(TestResource resource) {
        if (this.status != Status.RESOLVED || resource.status != Status.SETUP || !this.equals(resource)) {
            throw new IllegalStateException();
        }
        this.status = Status.SETUP;
        resource.status = Status.RECYCLED;
    }

    public void tearDown() throws Exception {
        if (this.status != Status.SETUP) {
            throw new IllegalStateException();
        }
        for (Invocable finalizer : this.finalizers) {
            finalizer.execute(this.target);
        }
        this.status = Status.RESOLVED;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TestResource) {
            TestResource other = (TestResource)obj;
            return this.target == other.target && this.directDependencies.equals(other.directDependencies);
        }
        return false;
    }

    public int hashCode() {
        int hashCode;
        if (this.hasHashCode) {
            hashCode = this.hashCode;
        } else {
            hashCode = new HashCodeBuilder().append(this.target).append(this.directDependencies).toHashCode();
            if (this.status != Status.UNRESOLVED) {
                this.hashCode = hashCode;
            }
        }
        return hashCode;
    }

    public String toString() {
        Class<?> clazz = this.target.getClass();
        String simpleName = clazz.getSimpleName();
        if (simpleName.length() > 0) {
            return simpleName;
        }
        return "<anonymous " + clazz.getSuperclass().getSimpleName() + ">";
    }

    private static class FieldResetter
    implements Invocable {
        private final Field field;

        public FieldResetter(Field field) {
            this.field = field;
        }

        public void execute(Object object) throws Exception {
            this.field.set(object, null);
        }
    }

    private static class MethodInvocation
    implements Invocable {
        private final Method method;
        private final Object[] args;

        public MethodInvocation(Method method, Object[] args) {
            this.method = method;
            this.args = args;
        }

        public void execute(Object object) throws Exception {
            try {
                this.method.invoke(object, this.args);
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                throw ex;
            }
        }
    }

    private static interface Invocable {
        public void execute(Object var1) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Status {
        UNRESOLVED,
        RESOLVED,
        SETUP,
        RECYCLED;

    }
}

