/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.tests;

import java.util.LinkedHashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.axis2.transport.testkit.name.Key;
import org.apache.axis2.transport.testkit.name.NameUtils;
import org.apache.axis2.transport.testkit.tests.TestResourceSet;
import org.apache.axis2.transport.testkit.util.LogManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Key(value="test")
public abstract class ManagedTestCase
extends TestCase {
    private final TestResourceSet resourceSet = new TestResourceSet();
    private Map<String, String> nameComponents;
    private String id;
    private boolean managed;
    private Class<?> testClass;

    public ManagedTestCase(Object ... resources) {
        this.resourceSet.addResources(resources);
        this.addResource(LogManager.INSTANCE);
    }

    protected void addResource(Object resource) {
        this.resourceSet.addResource(resource);
    }

    public Map<String, String> getNameComponents() {
        if (this.nameComponents == null) {
            this.nameComponents = new LinkedHashMap<String, String>();
            NameUtils.getNameComponents(this.nameComponents, (Object)this);
            this.resourceSet.resolve();
            for (Object resource : this.resourceSet.getResources()) {
                NameUtils.getNameComponents(this.nameComponents, resource);
            }
        }
        return this.nameComponents;
    }

    public void init(String id, boolean managed, Class<?> testClass) {
        this.id = id;
        this.managed = managed;
        this.testClass = testClass;
    }

    public String getId() {
        return this.id != null ? this.id : this.getName();
    }

    public Class<?> getTestClass() {
        return this.testClass != null ? this.testClass : ((Object)((Object)this)).getClass();
    }

    public String getName() {
        String testName = super.getName();
        if (testName == null) {
            StringBuilder buffer = new StringBuilder();
            if (this.id != null) {
                buffer.append(this.id);
                buffer.append(':');
            }
            boolean first = true;
            for (Map.Entry<String, String> entry : this.getNameComponents().entrySet()) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(',');
                }
                buffer.append(entry.getKey());
                buffer.append('=');
                buffer.append(entry.getValue());
            }
            testName = buffer.toString();
            this.setName(testName);
        }
        return testName;
    }

    public TestResourceSet getResourceSet() {
        return this.resourceSet;
    }

    protected void setUp() throws Exception {
        if (!this.managed) {
            LogManager.INSTANCE.setTestCase(this);
            this.resourceSet.setUp();
        }
    }

    protected void tearDown() throws Exception {
        if (!this.managed) {
            this.resourceSet.tearDown();
            LogManager.INSTANCE.setTestCase(null);
        }
    }

    public String toString() {
        return this.getName() + "(" + this.testClass.getName() + ")";
    }
}

