/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.message;

import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;

public class XMLMessage {
    private final Type type;
    private final OMElement payload;
    private final Attachments attachments;

    public XMLMessage(OMElement payload, Type type, Attachments attachments) {
        this.payload = payload;
        this.type = type;
        this.attachments = attachments;
    }

    public XMLMessage(OMElement payload, Type type) {
        this(payload, type, null);
    }

    public Type getType() {
        return this.type;
    }

    public OMElement getPayload() {
        return this.payload;
    }

    public OMElement getMessageElement() {
        if (this.type == Type.POX) {
            return this.payload;
        }
        SOAPFactory factory = this.type == Type.SOAP11 ? OMAbstractFactory.getSOAP11Factory() : OMAbstractFactory.getSOAP12Factory();
        SOAPEnvelope envelope = factory.getDefaultEnvelope();
        envelope.getBody().addChild((OMNode)this.payload);
        return envelope;
    }

    public Attachments getAttachments() {
        return this.attachments;
    }

    public static Type getTypeFromContentType(ContentType contentType) {
        String baseType = contentType.getBaseType();
        Type type = null;
        for (Type candidate : Type.values()) {
            if (!candidate.getContentType().getBaseType().equalsIgnoreCase(baseType)) continue;
            type = candidate;
            break;
        }
        return type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SOAP11("text/xml"),
        SOAP12("application/soap+xml"),
        POX("application/xml"),
        SWA("multipart/related");

        private final String contentType;

        private Type(String contentType) {
            this.contentType = contentType;
        }

        public ContentType getContentType() {
            try {
                return new ContentType(this.contentType);
            }
            catch (ParseException ex) {
                throw new Error(ex);
            }
        }
    }
}

