/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.message;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.internet.ContentType;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.OMMultipartWriter;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.transport.base.BaseConstants;
import org.apache.axis2.transport.testkit.client.ClientOptions;
import org.apache.axis2.transport.testkit.message.AxisMessage;
import org.apache.axis2.transport.testkit.message.XMLMessage;
import org.apache.axis2.transport.testkit.util.ContentTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface MessageEncoder<T, U> {
    public static final MessageEncoder<XMLMessage, AxisMessage> XML_TO_AXIS = new MessageEncoder<XMLMessage, AxisMessage>(){

        @Override
        public ContentType getContentType(ClientOptions options, ContentType contentType) {
            return contentType;
        }

        @Override
        public AxisMessage encode(ClientOptions options, XMLMessage message) throws Exception {
            XMLMessage.Type type = message.getType();
            AxisMessage result = new AxisMessage();
            SOAPFactory factory = type == XMLMessage.Type.SOAP12 || type == XMLMessage.Type.SWA ? OMAbstractFactory.getSOAP12Factory() : OMAbstractFactory.getSOAP11Factory();
            result.setMessageType(type.getContentType().toString());
            SOAPEnvelope envelope = factory.getDefaultEnvelope();
            envelope.getBody().addChild((OMNode)message.getPayload());
            result.setEnvelope(envelope);
            if (type == XMLMessage.Type.SWA) {
                result.setAttachments(message.getAttachments());
            }
            return result;
        }
    };
    public static final MessageEncoder<XMLMessage, byte[]> XML_TO_BYTE = new MessageEncoder<XMLMessage, byte[]>(){

        @Override
        public ContentType getContentType(ClientOptions options, ContentType contentType) throws Exception {
            if (contentType.getBaseType().equals(XMLMessage.Type.SWA.getContentType().getBaseType())) {
                OMOutputFormat outputFormat = new OMOutputFormat();
                outputFormat.setMimeBoundary(options.getMimeBoundary());
                outputFormat.setRootContentId(options.getRootContentId());
                return new ContentType(outputFormat.getContentTypeForSwA("application/soap+xml"));
            }
            return ContentTypeUtil.addCharset(contentType, options.getCharset());
        }

        @Override
        public byte[] encode(ClientOptions options, XMLMessage message) throws Exception {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OMOutputFormat outputFormat = new OMOutputFormat();
            outputFormat.setCharSetEncoding(options.getCharset());
            outputFormat.setIgnoreXMLDeclaration(true);
            if (message.getType() == XMLMessage.Type.SWA) {
                outputFormat.setMimeBoundary(options.getMimeBoundary());
                outputFormat.setRootContentId(options.getRootContentId());
                OMMultipartWriter mpw = new OMMultipartWriter((OutputStream)baos, outputFormat);
                OutputStream out = mpw.writeRootPart();
                message.getMessageElement().serializeAndConsume(out);
                out.close();
                Attachments attachments = message.getAttachments();
                for (String id : attachments.getAllContentIDs()) {
                    mpw.writePart(attachments.getDataHandler(id), id);
                }
                mpw.complete();
            } else {
                message.getMessageElement().serializeAndConsume((OutputStream)baos, outputFormat);
            }
            return baos.toByteArray();
        }
    };
    public static final MessageEncoder<XMLMessage, String> XML_TO_STRING = new MessageEncoder<XMLMessage, String>(){

        @Override
        public ContentType getContentType(ClientOptions options, ContentType contentType) {
            return contentType;
        }

        @Override
        public String encode(ClientOptions options, XMLMessage message) throws Exception {
            if (message.getType() == XMLMessage.Type.SWA) {
                throw new UnsupportedOperationException();
            }
            OMOutputFormat format = new OMOutputFormat();
            format.setIgnoreXMLDeclaration(true);
            StringWriter sw = new StringWriter();
            message.getMessageElement().serializeAndConsume((Writer)sw, format);
            return sw.toString();
        }
    };
    public static final MessageEncoder<byte[], AxisMessage> BINARY_WRAPPER = new MessageEncoder<byte[], AxisMessage>(){

        @Override
        public ContentType getContentType(ClientOptions options, ContentType contentType) {
            return contentType;
        }

        @Override
        public AxisMessage encode(ClientOptions options, byte[] message) throws Exception {
            AxisMessage result = new AxisMessage();
            result.setMessageType("application/octet-stream");
            SOAPFactory factory = OMAbstractFactory.getSOAP11Factory();
            SOAPEnvelope envelope = factory.getDefaultEnvelope();
            OMElement wrapper = factory.createOMElement(BaseConstants.DEFAULT_BINARY_WRAPPER);
            DataHandler dataHandler = new DataHandler((DataSource)new ByteArrayDataSource(message));
            wrapper.addChild((OMNode)factory.createOMText((Object)dataHandler, true));
            envelope.getBody().addChild((OMNode)wrapper);
            result.setEnvelope(envelope);
            return result;
        }
    };
    public static final MessageEncoder<String, AxisMessage> TEXT_WRAPPER = new MessageEncoder<String, AxisMessage>(){

        @Override
        public ContentType getContentType(ClientOptions options, ContentType contentType) {
            return contentType;
        }

        @Override
        public AxisMessage encode(ClientOptions options, String message) throws Exception {
            AxisMessage result = new AxisMessage();
            result.setMessageType("text/plain");
            SOAPFactory factory = OMAbstractFactory.getSOAP11Factory();
            SOAPEnvelope envelope = factory.getDefaultEnvelope();
            OMElement wrapper = factory.createOMElement(BaseConstants.DEFAULT_TEXT_WRAPPER);
            wrapper.addChild((OMNode)factory.createOMText(message));
            envelope.getBody().addChild((OMNode)wrapper);
            result.setEnvelope(envelope);
            return result;
        }
    };
    public static final MessageEncoder<String, byte[]> STRING_TO_BYTE = new MessageEncoder<String, byte[]>(){

        @Override
        public ContentType getContentType(ClientOptions options, ContentType contentType) {
            return ContentTypeUtil.addCharset(contentType, options.getCharset());
        }

        @Override
        public byte[] encode(ClientOptions options, String message) throws Exception {
            return message.getBytes(options.getCharset());
        }
    };

    public ContentType getContentType(ClientOptions var1, ContentType var2) throws Exception;

    public U encode(ClientOptions var1, T var2) throws Exception;
}

