/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedList;
import javax.activation.DataHandler;
import javax.mail.internet.ContentType;
import junit.framework.Assert;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.transport.base.BaseConstants;
import org.apache.axis2.transport.testkit.message.AxisMessage;
import org.apache.axis2.transport.testkit.message.RESTMessage;
import org.apache.axis2.transport.testkit.message.XMLMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface MessageDecoder<T, U> {
    public static final MessageDecoder<AxisMessage, byte[]> AXIS_TO_BYTE = new MessageDecoder<AxisMessage, byte[]>(){

        @Override
        public byte[] decode(ContentType contentType, AxisMessage message) throws Exception {
            SOAPEnvelope envelope = message.getEnvelope();
            OMElement wrapper = envelope.getBody().getFirstElement();
            Assert.assertEquals((Object)BaseConstants.DEFAULT_BINARY_WRAPPER, (Object)wrapper.getQName());
            OMNode child = wrapper.getFirstOMChild();
            Assert.assertTrue((boolean)(child instanceof OMText));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ((DataHandler)((OMText)child).getDataHandler()).writeTo((OutputStream)baos);
            return baos.toByteArray();
        }
    };
    public static final MessageDecoder<AxisMessage, String> AXIS_TO_STRING = new MessageDecoder<AxisMessage, String>(){

        @Override
        public String decode(ContentType contentType, AxisMessage message) throws Exception {
            SOAPEnvelope envelope = message.getEnvelope();
            OMElement wrapper = envelope.getBody().getFirstElement();
            Assert.assertEquals((Object)BaseConstants.DEFAULT_TEXT_WRAPPER, (Object)wrapper.getQName());
            return wrapper.getText();
        }
    };
    public static final MessageDecoder<AxisMessage, XMLMessage> AXIS_TO_XML = new MessageDecoder<AxisMessage, XMLMessage>(){

        @Override
        public XMLMessage decode(ContentType contentType, AxisMessage message) throws Exception {
            XMLMessage.Type type;
            Attachments attachments = message.getAttachments();
            if (attachments != null) {
                type = XMLMessage.Type.SWA;
            } else {
                type = null;
                for (XMLMessage.Type candidate : XMLMessage.Type.values()) {
                    if (!candidate.getContentType().equals(message.getMessageType())) continue;
                    type = candidate;
                    break;
                }
                if (type == null) {
                    type = XMLMessage.Type.POX;
                }
            }
            return new XMLMessage(message.getEnvelope().getBody().getFirstElement(), type, attachments);
        }
    };
    public static final MessageDecoder<AxisMessage, RESTMessage> AXIS_TO_REST = new MessageDecoder<AxisMessage, RESTMessage>(){

        @Override
        public RESTMessage decode(ContentType contentType, AxisMessage message) throws Exception {
            LinkedList<RESTMessage.Parameter> parameters = new LinkedList<RESTMessage.Parameter>();
            OMElement content = message.getEnvelope().getBody().getFirstElement();
            Iterator it = content.getChildElements();
            while (it.hasNext()) {
                OMElement child = (OMElement)it.next();
                parameters.add(new RESTMessage.Parameter(child.getLocalName(), child.getText()));
            }
            return new RESTMessage(parameters.toArray(new RESTMessage.Parameter[parameters.size()]));
        }
    };
    public static final MessageDecoder<byte[], XMLMessage> BYTE_TO_XML = new MessageDecoder<byte[], XMLMessage>(){

        @Override
        public XMLMessage decode(ContentType contentType, byte[] message) throws Exception {
            XMLMessage.Type type = XMLMessage.getTypeFromContentType(contentType);
            if (type == null) {
                throw new Exception("Unrecognized content type " + contentType);
            }
            ByteArrayInputStream in = new ByteArrayInputStream(message);
            if (type == XMLMessage.Type.SWA) {
                Attachments attachments = new Attachments((InputStream)in, contentType.toString());
                OMElement payload = OMXMLBuilderFactory.createSOAPModelBuilder((InputStream)attachments.getSOAPPartInputStream(), null).getSOAPEnvelope().getBody().getFirstElement();
                return new XMLMessage(payload, type, attachments);
            }
            String charset = contentType.getParameter("charset");
            OMElement payload = type == XMLMessage.Type.POX ? OMXMLBuilderFactory.createOMBuilder((InputStream)in, (String)charset).getDocumentElement() : OMXMLBuilderFactory.createSOAPModelBuilder((InputStream)in, (String)charset).getSOAPEnvelope().getBody().getFirstElement();
            return new XMLMessage(payload, type);
        }
    };
    public static final MessageDecoder<String, XMLMessage> STRING_TO_XML = new MessageDecoder<String, XMLMessage>(){

        @Override
        public XMLMessage decode(ContentType contentType, String message) throws Exception {
            XMLMessage.Type type = XMLMessage.getTypeFromContentType(contentType);
            if (type == null) {
                throw new Exception("Unrecognized content type " + contentType);
            }
            OMElement payload = type == XMLMessage.Type.POX ? OMXMLBuilderFactory.createOMBuilder((Reader)new StringReader(message)).getDocumentElement() : OMXMLBuilderFactory.createSOAPModelBuilder((Reader)new StringReader(message)).getSOAPEnvelope().getBody().getFirstElement();
            return new XMLMessage(payload, type);
        }
    };
    public static final MessageDecoder<byte[], String> BYTE_TO_STRING = new MessageDecoder<byte[], String>(){

        @Override
        public String decode(ContentType contentType, byte[] message) throws Exception {
            String charset = contentType.getParameter("charset");
            return new String(message, charset);
        }
    };

    public U decode(ContentType var1, T var2) throws Exception;
}

