/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.http;

import java.io.IOException;
import org.apache.axis2.transport.testkit.http.HttpChannel;
import org.apache.axis2.transport.testkit.http.JettyServer;
import org.apache.axis2.transport.testkit.tests.Setup;
import org.apache.axis2.transport.testkit.tests.TearDown;
import org.apache.axis2.transport.testkit.tests.Transient;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.handler.AbstractHttpHandler;

public abstract class JettyEndpoint {
    @Transient
    private JettyServer server;
    @Transient
    private HttpHandler handler;

    @Setup
    private void setUp(JettyServer server, HttpChannel channel) throws Exception {
        this.server = server;
        final String path = "/" + channel.getServiceName();
        this.handler = new AbstractHttpHandler(){

            public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
                if (pathInContext.equals(path)) {
                    JettyEndpoint.this.handle(pathParams, request, response);
                    request.setHandled(true);
                }
            }
        };
        server.getContext().addHandler(this.handler);
        this.handler.start();
    }

    @TearDown
    private void tearDown() throws Exception {
        this.handler.stop();
        this.server.getContext().removeHandler(this.handler);
    }

    protected abstract void handle(String var1, HttpRequest var2, HttpResponse var3) throws HttpException, IOException;
}

