/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.http;

import java.util.LinkedList;
import java.util.List;
import junit.framework.Test;
import org.apache.axis2.transport.testkit.ManagedTestSuite;
import org.apache.axis2.transport.testkit.TransportTestSuiteBuilder;
import org.apache.axis2.transport.testkit.axis2.TransportDescriptionFactory;
import org.apache.axis2.transport.testkit.axis2.client.AxisAsyncTestClient;
import org.apache.axis2.transport.testkit.axis2.client.AxisRequestResponseTestClient;
import org.apache.axis2.transport.testkit.axis2.client.AxisTestClientConfigurator;
import org.apache.axis2.transport.testkit.axis2.endpoint.AxisAsyncEndpoint;
import org.apache.axis2.transport.testkit.axis2.endpoint.AxisEchoEndpoint;
import org.apache.axis2.transport.testkit.channel.AsyncChannel;
import org.apache.axis2.transport.testkit.http.HttpChannel;
import org.apache.axis2.transport.testkit.http.JavaNetClient;
import org.apache.axis2.transport.testkit.http.JavaNetRESTClient;
import org.apache.axis2.transport.testkit.http.JettyByteArrayAsyncEndpoint;
import org.apache.axis2.transport.testkit.http.JettyEchoEndpoint;
import org.apache.axis2.transport.testkit.http.JettyRESTAsyncEndpoint;
import org.apache.axis2.transport.testkit.tests.misc.MinConcurrencyTest;

public class HttpTransportTestSuiteBuilder {
    private final ManagedTestSuite suite;
    private final TransportDescriptionFactory tdf;
    private final List<AxisTestClientConfigurator> axisTestClientConfigurators = new LinkedList<AxisTestClientConfigurator>();

    public HttpTransportTestSuiteBuilder(ManagedTestSuite suite, TransportDescriptionFactory tdf) {
        this.suite = suite;
        this.tdf = tdf;
    }

    public void addAxisTestClientConfigurator(AxisTestClientConfigurator configurator) {
        this.axisTestClientConfigurators.add(configurator);
    }

    public void build() {
        TransportTestSuiteBuilder builder = new TransportTestSuiteBuilder(this.suite);
        builder.addEnvironment(this.tdf);
        HttpChannel channel = new HttpChannel();
        builder.addAsyncChannel(channel, new Object[0]);
        builder.addByteArrayAsyncTestClient(new JavaNetClient(), new Object[0]);
        if (this.axisTestClientConfigurators.isEmpty()) {
            builder.addAxisAsyncTestClient(new AxisAsyncTestClient(), new Object[0]);
        } else {
            for (AxisTestClientConfigurator configurator : this.axisTestClientConfigurators) {
                builder.addAxisAsyncTestClient(new AxisAsyncTestClient(), configurator);
            }
        }
        builder.addRESTAsyncTestClient(new JavaNetRESTClient(), new Object[0]);
        builder.addAxisAsyncEndpoint(new AxisAsyncEndpoint(), new Object[0]);
        builder.addByteArrayAsyncEndpoint(new JettyByteArrayAsyncEndpoint(), new Object[0]);
        builder.addRESTAsyncEndpoint(new JettyRESTAsyncEndpoint(), new Object[0]);
        builder.addRequestResponseChannel(channel, new Object[0]);
        builder.addAxisRequestResponseTestClient(new AxisRequestResponseTestClient(), new Object[0]);
        builder.addEchoEndpoint(new AxisEchoEndpoint(), new Object[0]);
        builder.addEchoEndpoint(new JettyEchoEndpoint(), new Object[0]);
        builder.build();
        this.suite.addTest((Test)new MinConcurrencyTest(new AsyncChannel[]{new HttpChannel(), new HttpChannel()}, 2, false, new Object[]{this.tdf}));
    }
}

