/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.filter;

import java.text.ParseException;
import java.util.List;
import org.apache.axis2.transport.testkit.filter.AndExpression;
import org.apache.axis2.transport.testkit.filter.EqualityExpression;
import org.apache.axis2.transport.testkit.filter.FilterExpression;
import org.apache.axis2.transport.testkit.filter.NotExpression;
import org.apache.axis2.transport.testkit.filter.OrExpression;
import org.apache.axis2.transport.testkit.filter.PresenceExpression;
import org.apache.directory.shared.ldap.filter.AndNode;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.FilterParser;
import org.apache.directory.shared.ldap.filter.NotNode;
import org.apache.directory.shared.ldap.filter.OrNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterExpressionParser {
    private FilterExpressionParser() {
    }

    private static FilterExpression[] buildExpressions(List<ExprNode> nodes) {
        FilterExpression[] result = new FilterExpression[nodes.size()];
        int i = 0;
        for (ExprNode node : nodes) {
            result[i++] = FilterExpressionParser.buildExpression(node);
        }
        return result;
    }

    private static FilterExpression buildExpression(ExprNode node) {
        if (node instanceof AndNode) {
            return new AndExpression(FilterExpressionParser.buildExpressions(((AndNode)node).getChildren()));
        }
        if (node instanceof OrNode) {
            return new OrExpression(FilterExpressionParser.buildExpressions(((OrNode)node).getChildren()));
        }
        if (node instanceof NotNode) {
            return new NotExpression(FilterExpressionParser.buildExpression(((NotNode)node).getFirstChild()));
        }
        if (node instanceof EqualityNode) {
            EqualityNode equalityNode = (EqualityNode)node;
            return new EqualityExpression(equalityNode.getAttribute(), equalityNode.getValue().toString());
        }
        if (node instanceof PresenceNode) {
            return new PresenceExpression(((PresenceNode)node).getAttribute());
        }
        throw new UnsupportedOperationException("Node type " + node.getClass().getSimpleName() + " not supported");
    }

    public static FilterExpression parse(String filter) throws ParseException {
        return FilterExpressionParser.buildExpression(FilterParser.parse((String)filter));
    }
}

