/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.endpoint;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.mail.internet.ContentType;
import org.apache.axis2.transport.testkit.message.IncomingMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InOnlyEndpointSupport<M> {
    private final BlockingQueue<Event<M>> queue = new LinkedBlockingQueue<Event<M>>();

    public void putException(final Throwable ex) {
        this.queue.add(new Event<M>(){

            @Override
            public IncomingMessage<M> process() throws Throwable {
                throw ex;
            }
        });
    }

    public void putMessage(final ContentType contentType, final M data) {
        this.queue.add(new Event<M>(){

            @Override
            public IncomingMessage<M> process() throws Throwable {
                return new IncomingMessage<Object>(contentType, data);
            }
        });
    }

    public void putMessage(final IncomingMessage<M> message) {
        this.queue.add(new Event<M>(){

            @Override
            public IncomingMessage<M> process() throws Throwable {
                return message;
            }
        });
    }

    public void clear() {
        this.queue.clear();
    }

    public IncomingMessage<M> waitForMessage(int timeout) throws Throwable {
        Event<M> event = this.queue.poll(timeout, TimeUnit.MILLISECONDS);
        return event == null ? null : event.process();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Event<M> {
        public IncomingMessage<M> process() throws Throwable;
    }
}

