/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.endpoint;

import javax.mail.internet.ContentType;
import org.apache.axis2.transport.testkit.Adapter;
import org.apache.axis2.transport.testkit.endpoint.AsyncEndpoint;
import org.apache.axis2.transport.testkit.message.IncomingMessage;
import org.apache.axis2.transport.testkit.message.MessageDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncEndpointAdapter<M, N>
implements AsyncEndpoint<M>,
Adapter {
    private final AsyncEndpoint<N> target;
    private final MessageDecoder<N, M> decoder;

    public AsyncEndpointAdapter(AsyncEndpoint<N> target, MessageDecoder<N, M> decoder) {
        this.target = target;
        this.decoder = decoder;
    }

    @Override
    public AsyncEndpoint<N> getTarget() {
        return this.target;
    }

    @Override
    public void clear() throws Exception {
        this.target.clear();
    }

    @Override
    public IncomingMessage<M> waitForMessage(int timeout) throws Throwable {
        IncomingMessage<N> message = this.target.waitForMessage(timeout);
        if (message == null) {
            return null;
        }
        ContentType contentType = message.getContentType();
        return new IncomingMessage<M>(contentType, this.decoder.decode(contentType, message.getData()));
    }
}

