/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.doclet;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.apache.axis2.transport.testkit.doclet.Resource;
import org.apache.axis2.transport.testkit.doclet.ResourceInfo;

public class ResourceInfoDoclet {
    private static File outFile;

    public static boolean start(RootDoc root) throws IOException {
        ResourceInfoDoclet.parseOptions(root.options());
        ResourceInfo resourceInfo = new ResourceInfo();
        for (ClassDoc clazz : root.classes()) {
            Resource resource = null;
            for (MethodDoc method : clazz.methods()) {
                if (ResourceInfoDoclet.getAnnotation((ProgramElementDoc)method, "org.apache.axis2.transport.testkit.tests.Setup") == null) continue;
                if (resource == null) {
                    resource = new Resource(clazz.qualifiedName());
                }
                ParamTag[] paramTags = method.paramTags();
                for (Parameter parameter : method.parameters()) {
                    Type type = parameter.type();
                    String name = parameter.name();
                    String comment = null;
                    for (ParamTag paramTag : paramTags) {
                        if (!paramTag.parameterName().equals(name)) continue;
                        comment = paramTag.parameterComment();
                        break;
                    }
                    if (comment == null) {
                        comment = ResourceInfoDoclet.getFirstSentence((Doc)root.classNamed(type.qualifiedTypeName()));
                    }
                    resource.addDependency(type.qualifiedTypeName(), type.dimension().equals("[]") ? "0..*" : "1", comment);
                }
            }
            if (resource == null) continue;
            resourceInfo.addResource(resource);
        }
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(outFile));
        out.writeObject(resourceInfo);
        out.close();
        return true;
    }

    private static AnnotationDesc getAnnotation(ProgramElementDoc doc, String qualifiedName) {
        for (AnnotationDesc annotation : doc.annotations()) {
            if (!annotation.annotationType().qualifiedName().equals(qualifiedName)) continue;
            return annotation;
        }
        return null;
    }

    private static String getFirstSentence(Doc doc) {
        Tag[] tags = doc.firstSentenceTags();
        if (tags.length == 0) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (Tag tag : tags) {
            if (tag instanceof SeeTag) {
                buffer.append("{");
                buffer.append(tag.name());
                buffer.append(" ");
                buffer.append(((SeeTag)tag).referencedClassName());
                buffer.append("}");
                continue;
            }
            buffer.append(tag.text());
        }
        return buffer.toString();
    }

    private static void parseOptions(String[][] options) {
        for (String[] option : options) {
            if (!option[0].equals("-out")) continue;
            outFile = new File(option[1]);
            System.out.println("Output is going to " + outFile);
        }
    }

    public static int optionLength(String option) {
        if (option.equals("-out")) {
            return 2;
        }
        return 0;
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        boolean hasOut = false;
        for (String[] option : options) {
            String opt = option[0];
            if (!opt.equals("-out")) continue;
            hasOut = true;
        }
        if (!hasOut) {
            reporter.printError("No output file specified: -out <output file>");
            return false;
        }
        return true;
    }
}

