/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.axis2.client;

import javax.mail.internet.ContentType;
import junit.framework.Assert;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.testkit.axis2.MessageContextValidator;
import org.apache.axis2.transport.testkit.axis2.client.AxisTestClient;
import org.apache.axis2.transport.testkit.client.ClientOptions;
import org.apache.axis2.transport.testkit.client.RequestResponseTestClient;
import org.apache.axis2.transport.testkit.message.AxisMessage;
import org.apache.axis2.transport.testkit.message.IncomingMessage;
import org.apache.axis2.transport.testkit.tests.Setup;
import org.apache.axis2.transport.testkit.tests.Transient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisRequestResponseTestClient
extends AxisTestClient
implements RequestResponseTestClient<AxisMessage, AxisMessage> {
    @Transient
    private MessageContextValidator[] validators;

    @Setup
    private void setUp(MessageContextValidator[] validators) {
        this.validators = validators;
    }

    @Override
    public IncomingMessage<AxisMessage> sendMessage(ClientOptions options, ContentType contentType, AxisMessage message) throws Exception {
        MessageContext responseMsgContext = this.send(options, message, ServiceClient.ANON_OUT_IN_OP, true, "In");
        Assert.assertFalse((boolean)responseMsgContext.isServerSide());
        for (MessageContextValidator validator : this.validators) {
            validator.validate(responseMsgContext, true);
        }
        return new IncomingMessage<AxisMessage>(null, new AxisMessage(responseMsgContext));
    }
}

