/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit;

import java.text.ParseException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.axis2.transport.testkit.filter.FilterExpression;
import org.apache.axis2.transport.testkit.filter.FilterExpressionParser;
import org.apache.axis2.transport.testkit.tests.ManagedTestCase;
import org.apache.axis2.transport.testkit.tests.TestResourceSet;
import org.apache.axis2.transport.testkit.tests.TestResourceSetTransition;
import org.apache.axis2.transport.testkit.util.LogManager;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedTestSuite
extends TestSuite {
    private final Class<?> testClass;
    private final List<FilterExpression> excludes = new LinkedList<FilterExpression>();
    private final boolean reuseResources;
    private boolean invertExcludes;
    private int nextId = 1;

    public ManagedTestSuite(Class<?> testClass, boolean reuseResources) {
        this.testClass = testClass;
        this.reuseResources = reuseResources;
    }

    public ManagedTestSuite(Class<?> testClass) {
        this(testClass, true);
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public void addExclude(String filter) throws ParseException {
        this.excludes.add(FilterExpressionParser.parse(filter));
    }

    public void setInvertExcludes(boolean invertExcludes) {
        this.invertExcludes = invertExcludes;
    }

    public void addTest(Test test) {
        if (test instanceof ManagedTestCase) {
            ManagedTestCase ttest = (ManagedTestCase)test;
            Map<String, String> map = ttest.getNameComponents();
            boolean excluded = false;
            for (FilterExpression exclude : this.excludes) {
                if (!exclude.matches(map)) continue;
                excluded = true;
                break;
            }
            if (excluded != this.invertExcludes) {
                return;
            }
            ttest.init(StringUtils.leftPad((String)String.valueOf(this.nextId++), (int)4, (char)'0'), this.reuseResources, this.testClass);
            ttest.getResourceSet().resolve();
        }
        super.addTest(test);
    }

    public void run(TestResult result) {
        LogManager logManager = LogManager.INSTANCE;
        if (!this.reuseResources) {
            super.run(result);
        } else {
            TestResourceSet resourceSet = null;
            Enumeration e = this.tests();
            while (e.hasMoreElements()) {
                Test test = (Test)e.nextElement();
                if (test instanceof ManagedTestCase) {
                    ManagedTestCase ttest = (ManagedTestCase)test;
                    TestResourceSet newResourceSet = ttest.getResourceSet();
                    try {
                        if (resourceSet == null) {
                            logManager.setTestCase(ttest);
                            newResourceSet.setUp();
                        } else {
                            TestResourceSetTransition transition = new TestResourceSetTransition(resourceSet, newResourceSet);
                            transition.tearDown();
                            logManager.setTestCase(ttest);
                            transition.setUp();
                        }
                    }
                    catch (Throwable t) {
                        result.addError((Test)this, t);
                        return;
                    }
                    resourceSet = newResourceSet;
                }
                this.runTest(test, result);
            }
            if (resourceSet != null) {
                try {
                    resourceSet.tearDown();
                    logManager.setTestCase(null);
                }
                catch (Throwable t) {
                    result.addError((Test)this, t);
                    return;
                }
            }
        }
    }
}

