/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.receivers.RawXMLINOnlyMessageReceiver;
import org.apache.axis2.receivers.RawXMLINOutMessageReceiver;
import org.apache.axis2.transport.CustomAxisConfigurator;
import org.apache.axis2.transport.Echo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilsTransportServer {
    private final ListenerManager listnMgr;
    private final ConfigurationContext cfgCtx = ConfigurationContextFactory.createConfigurationContext((AxisConfigurator)new CustomAxisConfigurator());

    public UtilsTransportServer() throws AxisFault {
        this.listnMgr = new ListenerManager();
        this.cfgCtx.setTransportManager(this.listnMgr);
    }

    public void addTransport(TransportInDescription trpInDesc, TransportOutDescription trpDescOut) throws AxisFault {
        this.cfgCtx.getAxisConfiguration().addTransportIn(trpInDesc);
        if (trpDescOut != null) {
            trpDescOut.getSender().init(this.cfgCtx, trpDescOut);
            this.cfgCtx.getAxisConfiguration().addTransportOut(trpDescOut);
        }
    }

    public void addTransport(TransportInDescription trpInDesc) throws AxisFault {
        this.addTransport(trpInDesc, null);
    }

    public void start() throws Exception {
        this.listnMgr.init(this.cfgCtx);
        this.listnMgr.start();
    }

    public void stop() throws Exception {
        this.listnMgr.stop();
        this.listnMgr.destroy();
    }

    public void enableAddressing() throws AxisFault {
        this.cfgCtx.getAxisConfiguration().engageModule("addressing");
    }

    public ConfigurationContext getConfigurationContext() {
        return this.cfgCtx;
    }

    public AxisConfiguration getAxisConfiguration() {
        return this.cfgCtx.getAxisConfiguration();
    }

    public void deployEchoService(String name, List<Parameter> parameters) throws Exception {
        AxisService service = new AxisService(name);
        service.setClassLoader(Thread.currentThread().getContextClassLoader());
        service.addParameter(new Parameter("ServiceClass", (Object)Echo.class.getName()));
        InOutAxisOperation axisOp = new InOutAxisOperation(new QName("echoOMElement"));
        axisOp.setMessageReceiver((MessageReceiver)new RawXMLINOutMessageReceiver());
        axisOp.setStyle("rpc");
        service.addOperation((AxisOperation)axisOp);
        service.mapActionToOperation("http://ws.apache.org/namespaces/axis2/echoOMElement", (AxisOperation)axisOp);
        axisOp = new InOutAxisOperation(new QName("echoOMElementNoResponse"));
        axisOp.setMessageReceiver((MessageReceiver)new RawXMLINOnlyMessageReceiver());
        axisOp.setStyle("rpc");
        service.addOperation((AxisOperation)axisOp);
        service.mapActionToOperation("http://ws.apache.org/namespaces/axis2/echoOMElementNoResponse", (AxisOperation)axisOp);
        for (Parameter parameter : parameters) {
            service.addParameter(parameter);
        }
        this.cfgCtx.getAxisConfiguration().addService(service);
    }
}

