/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.sms.smpp;

import java.util.HashMap;
import org.apache.axis2.AxisFault;
import org.apache.axis2.transport.sms.SMSManager;
import org.apache.axis2.transport.sms.smpp.SMPPDispatcher;
import org.apache.axis2.transport.sms.smpp.SMPPImplManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsmpp.bean.AlertNotification;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DeliverSm;
import org.jsmpp.bean.DeliveryReceipt;
import org.jsmpp.bean.MessageType;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.MessageReceiverListener;
import org.jsmpp.util.InvalidDeliveryReceiptException;

public class SMPPListener
implements MessageReceiverListener {
    protected Log log = LogFactory.getLog(this.getClass());
    private SMSManager smsManeger;

    public SMPPListener(SMSManager manager) {
        this.smsManeger = manager;
    }

    public void onAcceptDeliverSm(DeliverSm deliverSm) throws ProcessRequestException {
        if (MessageType.SMSC_DEL_RECEIPT.containedIn(deliverSm.getEsmClass())) {
            try {
                DeliveryReceipt delReceipt = deliverSm.getShortMessageAsDeliveryReceipt();
                long id = Long.parseLong(delReceipt.getId()) & 0xFFFFFFFFFFFFFFFFL;
                String messageId = Long.toString(id, 16).toUpperCase();
                this.log.debug((Object)("Receiving delivery receipt for message '" + messageId + " ' from " + deliverSm.getSourceAddr() + " to " + deliverSm.getDestAddress() + " : " + delReceipt));
            }
            catch (InvalidDeliveryReceiptException e) {
                this.log.debug((Object)"Failed getting delivery receipt", (Throwable)e);
            }
        } else {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put(SMPPImplManager.SOURCE_ADDRESS_TON, TypeOfNumber.valueOf((byte)deliverSm.getSourceAddrTon()).toString());
            properties.put(SMPPImplManager.SOURCE_ADDRESS_NPI, NumberingPlanIndicator.valueOf((byte)deliverSm.getSourceAddrNpi()).toString());
            properties.put(SMPPImplManager.DESTINATION_ADDRESS_TON, TypeOfNumber.valueOf((byte)deliverSm.getDestAddrTon()).toString());
            properties.put(SMPPImplManager.DESTINATION_ADDRESS_NPI, NumberingPlanIndicator.valueOf((byte)deliverSm.getDestAddrNpi()).toString());
            try {
                new SMPPDispatcher(this.smsManeger).dispatch(deliverSm.getSourceAddr(), deliverSm.getDestAddress(), new String(deliverSm.getShortMessage()), properties);
            }
            catch (AxisFault axisFault) {
                this.log.debug((Object)"Error while dispatching SMPP message", (Throwable)axisFault);
            }
            this.log.debug((Object)("Receiving message : " + new String(deliverSm.getShortMessage())));
        }
    }

    public void onAcceptAlertNotification(AlertNotification alertNotification) {
    }

    public DataSmResult onAcceptDataSm(DataSm dataSm) throws ProcessRequestException {
        return null;
    }
}

