/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.sms.gsm;

import org.apache.axis2.AxisFault;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.sms.SMSImplManager;
import org.apache.axis2.transport.sms.SMSManager;
import org.apache.axis2.transport.sms.SMSMessage;
import org.apache.axis2.transport.sms.SMSTransportConstents;
import org.apache.axis2.transport.sms.gsm.GSMDispatcher;
import org.apache.axis2.transport.sms.gsm.GSMServiceRepository;
import org.apache.axis2.transport.sms.gsm.GSMTransportInDetails;
import org.apache.axis2.transport.sms.gsm.GSMTransportOutDetails;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.smslib.AGateway;
import org.smslib.OutboundMessage;
import org.smslib.Service;
import org.smslib.modem.SerialModemGateway;

public class GSMImplManager
implements SMSImplManager {
    protected Log log = LogFactory.getLog(this.getClass());
    private GSMTransportInDetails gsmTransportInDetails = GSMTransportInDetails.getInstance();
    private GSMTransportOutDetails gsmTransportOutDetails = GSMTransportOutDetails.getInstance();
    private GSMDispatcher dispatcher;
    private Service service = null;
    private SerialModemGateway gateway;
    private GSMServiceRepository serviceRepo = GSMServiceRepository.getInstence();
    private SMSManager smsInManeger;

    public void start() {
        if (this.serviceRepo.gatewayInUse(this.gsmTransportInDetails.getGatewayId())) {
            this.service = this.serviceRepo.getService(this.gsmTransportInDetails.getGatewayId());
            return;
        }
        this.service = new Service();
        this.gateway = new SerialModemGateway(this.gsmTransportInDetails.getGatewayId(), this.gsmTransportInDetails.getComPort(), this.gsmTransportInDetails.getBaudRate(), this.gsmTransportInDetails.getManufacturer(), this.gsmTransportInDetails.getModel());
        this.gateway.setProtocol(AGateway.Protocols.PDU);
        this.gateway.setInbound(true);
        this.gateway.setOutbound(true);
        this.gateway.setSimPin("0000");
        try {
            this.service.addGateway((AGateway)this.gateway);
            this.service.startService();
            this.serviceRepo.addService(this.gsmTransportInDetails.getGatewayId(), this.service);
            this.dispatcher = new GSMDispatcher(this.service, this.smsInManeger);
            this.dispatcher.setPollInterval(this.gsmTransportInDetails.getModemPollInterval());
            Thread thread = new Thread(this.dispatcher);
            thread.start();
            System.out.println("[Axis2] Started in Port :" + this.gsmTransportInDetails.getComPort() + " ");
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
    }

    public void stop() {
        try {
            this.dispatcher.stopPolling();
            this.service.stopService();
            if (this.serviceRepo.gatewayInUse(this.gsmTransportInDetails.getGatewayId())) {
                this.serviceRepo.removeService(this.gsmTransportInDetails.getGatewayId());
            }
            if (this.serviceRepo.gatewayInUse(this.gsmTransportOutDetails.getGatewayId())) {
                this.serviceRepo.removeService(this.gsmTransportOutDetails.getGatewayId());
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
    }

    public void setTransportOutDetails(TransportOutDescription transportOutDetails) throws AxisFault {
        if (transportOutDetails.getParameter(SMSTransportConstents.MODEM_GATEWAY_ID) == null) {
            throw new AxisFault("GATEWAY ID NOT SET for the SMS transprot");
        }
        this.gsmTransportOutDetails.setGatewayId((String)transportOutDetails.getParameter(SMSTransportConstents.MODEM_GATEWAY_ID).getValue());
        if (transportOutDetails.getParameter(SMSTransportConstents.COM_PORT) == null) {
            throw new AxisFault("COM PORT NOT SET for the SMS transprot");
        }
        this.gsmTransportOutDetails.setComPort((String)transportOutDetails.getParameter(SMSTransportConstents.COM_PORT).getValue());
        if (transportOutDetails.getParameter(SMSTransportConstents.BAUD_RATE) == null) {
            throw new AxisFault("BAUD RATE NOT SET for the SMS transprot");
        }
        int bRate = Integer.parseInt((String)transportOutDetails.getParameter(SMSTransportConstents.BAUD_RATE).getValue());
        this.gsmTransportOutDetails.setBaudRate(bRate);
        if (transportOutDetails.getParameter(SMSTransportConstents.MANUFACTURER) == null) {
            throw new AxisFault("Manufactuer NOT SET for the SMS transprot");
        }
        this.gsmTransportOutDetails.setManufacturer((String)transportOutDetails.getParameter(SMSTransportConstents.MANUFACTURER).getValue());
        if (transportOutDetails.getParameter(SMSTransportConstents.MODEL) == null) {
            throw new AxisFault("Model NOT SET for the SMS transprot");
        }
        this.gsmTransportOutDetails.setModel((String)transportOutDetails.getParameter(SMSTransportConstents.MODEL).getValue());
    }

    public void setTransportInDetails(TransportInDescription transportInDetails) throws AxisFault {
        if (transportInDetails.getParameter(SMSTransportConstents.MODEM_GATEWAY_ID) == null) {
            throw new AxisFault("GATEWAY ID NOT SET for the SMS transprot");
        }
        this.gsmTransportInDetails.setGatewayId((String)transportInDetails.getParameter(SMSTransportConstents.MODEM_GATEWAY_ID).getValue());
        if (transportInDetails.getParameter(SMSTransportConstents.COM_PORT) == null) {
            throw new AxisFault("COM PORT NOT SET for the SMS transprot");
        }
        this.gsmTransportInDetails.setComPort((String)transportInDetails.getParameter(SMSTransportConstents.COM_PORT).getValue());
        if (transportInDetails.getParameter(SMSTransportConstents.BAUD_RATE) == null) {
            throw new AxisFault("BAUD RATE NOT SET for the SMS transprot");
        }
        int bRate = Integer.parseInt((String)transportInDetails.getParameter(SMSTransportConstents.BAUD_RATE).getValue());
        this.gsmTransportInDetails.setBaudRate(bRate);
        if (transportInDetails.getParameter(SMSTransportConstents.MANUFACTURER) == null) {
            throw new AxisFault("Manufactuer NOT SET for the SMS transprot");
        }
        this.gsmTransportInDetails.setManufacturer((String)transportInDetails.getParameter(SMSTransportConstents.MANUFACTURER).getValue());
        if (transportInDetails.getParameter(SMSTransportConstents.MODEL) == null) {
            throw new AxisFault("Model NOT SET for the SMS transprot");
        }
        this.gsmTransportInDetails.setModel((String)transportInDetails.getParameter(SMSTransportConstents.MODEL).getValue());
        if (transportInDetails.getParameter(SMSTransportConstents.MODEM_POLL_INTERVAL) != null) {
            String pollTime = (String)transportInDetails.getParameter(SMSTransportConstents.MODEM_POLL_INTERVAL).getValue();
            this.gsmTransportInDetails.setModemPollInterval(Long.parseLong(pollTime));
        }
    }

    public void sendSMS(SMSMessage sm) {
        if (this.service == null && !this.serviceRepo.gatewayInUse(this.gsmTransportOutDetails.getGatewayId())) {
            this.service = new Service();
            this.gateway = new SerialModemGateway(this.gsmTransportOutDetails.getGatewayId(), this.gsmTransportOutDetails.getComPort(), this.gsmTransportOutDetails.getBaudRate(), this.gsmTransportOutDetails.getManufacturer(), this.gsmTransportOutDetails.getModel());
            this.gateway.setProtocol(AGateway.Protocols.PDU);
            this.gateway.setOutbound(true);
            this.gateway.setSimPin("0000");
            try {
                this.service.addGateway((AGateway)this.gateway);
                this.service.startService();
            }
            catch (Exception e) {
                this.log.error((Object)e);
            }
        } else if (this.serviceRepo.gatewayInUse(this.gsmTransportOutDetails.getGatewayId())) {
            this.service = this.serviceRepo.getService(this.gsmTransportOutDetails.getGatewayId());
        }
        OutboundMessage msg = new OutboundMessage(sm.getReceiver(), sm.getContent());
        try {
            this.service.sendMessage(msg);
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
    }

    public void setSMSInManager(SMSManager manager) {
        this.smsInManeger = manager;
    }

    public SMSManager getSMSInManager() {
        return this.smsInManeger;
    }
}

