/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import javax.servlet.http.HttpServletRequest;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxisServletListener
implements TransportListener {
    private static final Log log = LogFactory.getLog(AxisServletListener.class);
    private String scheme;
    private int port;
    private ConfigurationContext configurationContext;
    private TransportInDescription transportInDescription;

    public void init(ConfigurationContext configurationContext, TransportInDescription transportInDescription) throws AxisFault {
        this.configurationContext = configurationContext;
        this.transportInDescription = transportInDescription;
        this.scheme = transportInDescription.getName();
        if (!"http".equals(this.scheme) && !"https".equals(this.scheme)) {
            throw new AxisFault(AxisServletListener.class.getName() + " can only be used for http or https");
        }
        Parameter param = transportInDescription.getParameter("port");
        if (param != null) {
            try {
                this.port = Integer.parseInt((String)param.getValue());
            }
            catch (NumberFormatException ex) {
                throw new AxisFault("Invalid port number");
            }
        } else {
            this.port = -1;
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void start() throws AxisFault {
    }

    public void stop() throws AxisFault {
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        if (this.port == -1) {
            throw new AxisFault("Port number for transport " + this.scheme + " has not yet been detected");
        }
        return HTTPTransportUtils.getEPRsForService(this.configurationContext, this.transportInDescription, serviceName, ip, this.port);
    }

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        return this.getEPRsForService(serviceName, ip)[0];
    }

    public SessionContext getSessionContext(MessageContext messageContext) {
        HttpServletRequest req = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        SessionContext sessionContext = (SessionContext)req.getSession(true).getAttribute("SessionContext");
        String sessionId = req.getSession().getId();
        if (sessionContext == null) {
            sessionContext = new SessionContext(null);
            sessionContext.setCookieID(sessionId);
            req.getSession().setAttribute("SessionContext", (Object)sessionContext);
        }
        messageContext.setSessionContext(sessionContext);
        messageContext.setProperty("SessionId", (Object)sessionId);
        return sessionContext;
    }

    public void destroy() {
    }
}

