/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.base.AbstractTransportSender;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.transport.udp.UDPOutTransportInfo;
import org.apache.commons.logging.LogFactory;

public class UDPSender
extends AbstractTransportSender {
    public UDPSender() {
        this.log = LogFactory.getLog(UDPSender.class);
    }

    public void init(ConfigurationContext cfgCtx, TransportOutDescription transportOut) throws AxisFault {
        super.init(cfgCtx, transportOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(MessageContext msgContext, String targetEPR, OutTransportInfo outTransportInfo) throws AxisFault {
        UDPOutTransportInfo udpOutInfo = new UDPOutTransportInfo(targetEPR);
        MessageFormatter messageFormatter = TransportUtils.getMessageFormatter((MessageContext)msgContext);
        OMOutputFormat format = BaseUtils.getOMOutputFormat(msgContext);
        format.setContentType(udpOutInfo.getContentType());
        byte[] payload = messageFormatter.getBytes(msgContext, format);
        try {
            DatagramSocket socket = new DatagramSocket();
            try {
                socket.send(new DatagramPacket(payload, payload.length, InetAddress.getByName(udpOutInfo.getHost()), udpOutInfo.getPort()));
            }
            finally {
                socket.close();
            }
        }
        catch (IOException ex) {
            throw new AxisFault("Unable to send packet", (Throwable)ex);
        }
    }
}

