/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.sms.gsm;

import java.util.ArrayList;
import org.apache.axis2.transport.sms.SMSManager;
import org.apache.axis2.transport.sms.SMSMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.smslib.InboundMessage;
import org.smslib.Service;

public class GSMDispatcher
implements Runnable {
    protected Log log = LogFactory.getLog(this.getClass());
    private boolean keepPolling = true;
    private Service service;
    private long pollInterval = 5000L;
    private SMSManager smsManager;

    public GSMDispatcher(Service service, SMSManager manager) {
        this.service = service;
        this.smsManager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.keepPolling) {
            ArrayList arrayList = new ArrayList();
            try {
                this.service.readMessages(arrayList, InboundMessage.MessageClasses.UNREAD);
                for (InboundMessage msg : arrayList) {
                    SMSMessage sms = null;
                    GSMDispatcher gSMDispatcher = this;
                    synchronized (gSMDispatcher) {
                        sms = new SMSMessage(msg.getOriginator(), null, msg.getText(), SMSMessage.IN_MESSAGE);
                    }
                    this.smsManager.dispatchToAxis2(sms);
                    this.service.deleteMessage(msg);
                }
            }
            catch (Exception ex) {
                this.log.error((Object)"Error Occured while reading messages", (Throwable)ex);
            }
            try {
                Thread.sleep(this.pollInterval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void stopPolling() {
        this.keepPolling = false;
    }

    public void setPollInterval(long pollInterval) {
        this.pollInterval = pollInterval;
    }
}

