/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.saaj.AttachmentPartImpl;
import org.apache.axis2.saaj.MimeHeadersEx;
import org.apache.axis2.saaj.SOAPEnvelopeImpl;
import org.apache.axis2.saaj.SOAPPartImpl;

public class SOAPMessageImpl
extends SOAPMessage {
    private SOAPPart soapPart;
    private Collection attachmentParts = new ArrayList();
    private MimeHeadersEx mimeHeaders;
    private Map props = new Hashtable();
    private boolean saveRequired;

    public SOAPMessageImpl(SOAPEnvelopeImpl soapEnvelope) {
        String contentType = null;
        if (this.mimeHeaders != null) {
            String[] contentTypes = this.mimeHeaders.getHeader("Content-Type");
            contentType = contentTypes != null ? contentTypes[0] : null;
        }
        this.setCharsetEncoding(contentType);
        this.soapPart = new SOAPPartImpl(this, soapEnvelope);
        this.mimeHeaders = new MimeHeadersEx();
    }

    public SOAPMessageImpl(InputStream inputstream, MimeHeaders mimeHeaders) throws SOAPException {
        String contentType = null;
        if (mimeHeaders != null) {
            String[] contentTypes = mimeHeaders.getHeader("Content-Type");
            contentType = contentTypes != null ? contentTypes[0] : null;
        }
        this.setCharsetEncoding(contentType);
        if (contentType == null || contentType.indexOf("multipart/related;") != 0) {
            this.soapPart = new SOAPPartImpl(this, inputstream);
        }
        this.mimeHeaders = mimeHeaders == null ? new MimeHeadersEx() : new MimeHeadersEx(mimeHeaders);
    }

    public String getContentDescription() {
        String[] values = this.mimeHeaders.getHeader("Content-Description");
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public void setContentDescription(String description) {
        this.mimeHeaders.setHeader("Content-Description", description);
    }

    public SOAPPart getSOAPPart() {
        return this.soapPart;
    }

    public void removeAllAttachments() {
        this.attachmentParts.clear();
    }

    public int countAttachments() {
        return this.attachmentParts.size();
    }

    public Iterator getAttachments() {
        return this.attachmentParts.iterator();
    }

    public Iterator getAttachments(MimeHeaders headers) {
        ArrayList<AttachmentPartImpl> matchingAttachmentParts = new ArrayList<AttachmentPartImpl>();
        Iterator iterator = this.getAttachments();
        while (iterator.hasNext()) {
            AttachmentPartImpl part = (AttachmentPartImpl)iterator.next();
            if (!part.matches(headers)) continue;
            matchingAttachmentParts.add(part);
        }
        return matchingAttachmentParts.iterator();
    }

    public void addAttachmentPart(AttachmentPart attachmentPart) {
        if (attachmentPart != null) {
            this.attachmentParts.add(attachmentPart);
            this.mimeHeaders.setHeader("Content-Type", "multipart/related");
        }
    }

    public AttachmentPart createAttachmentPart() {
        return new AttachmentPartImpl();
    }

    public MimeHeaders getMimeHeaders() {
        return this.mimeHeaders;
    }

    public void saveChanges() throws SOAPException {
        this.saveRequired = false;
    }

    public void setSaveRequired() {
        this.saveRequired = true;
    }

    public boolean saveRequired() {
        return this.saveRequired;
    }

    public void writeTo(OutputStream out) throws SOAPException, IOException {
        try {
            OMOutputFormat format = new OMOutputFormat();
            format.setCharSetEncoding((String)this.getProperty("javax.xml.soap.character-set-encoding"));
            String writeXmlDecl = (String)this.getProperty("javax.xml.soap.write-xml-declaration");
            if (writeXmlDecl == null || writeXmlDecl.equals("false")) {
                format.setIgnoreXMLDeclaration(true);
            }
            ((SOAPEnvelopeImpl)this.soapPart.getEnvelope()).getOMEnvelope().serialize(out, format);
            this.saveChanges();
        }
        catch (Exception e) {
            throw new SOAPException(e);
        }
    }

    public void setProperty(String property, Object value) {
        this.props.put(property, value);
    }

    public Object getProperty(String property) throws SOAPException {
        return this.props.get(property);
    }

    public SOAPHeader getSOAPHeader() throws SOAPException {
        return this.soapPart.getEnvelope().getHeader();
    }

    public SOAPBody getSOAPBody() throws SOAPException {
        return this.soapPart.getEnvelope().getBody();
    }

    private void setCharsetEncoding(String contentType) {
        int delimiterIndex;
        if (contentType != null && (delimiterIndex = contentType.lastIndexOf("charset")) > 0) {
            int charsetIndex;
            String charsetPart = contentType.substring(delimiterIndex);
            String charset = charsetPart.substring((charsetIndex = charsetPart.indexOf(61)) + 1).trim();
            if (charset.startsWith("\"") || charset.startsWith("'")) {
                charset = charset.substring(1, charset.length());
            }
            if (charset.endsWith("\"") || charset.endsWith("'")) {
                charset = charset.substring(0, charset.length() - 1);
            }
            this.setProperty("javax.xml.soap.character-set-encoding", charset);
        }
    }
}

